/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.jcr;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.moxtra.MoxtraClientStore;
import org.exoplatform.moxtra.MoxtraStoreException;
import org.exoplatform.moxtra.client.MoxtraClient;
import org.exoplatform.moxtra.client.MoxtraClientInitializer;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.jcr.JCR;
import org.exoplatform.moxtra.oauth2.AccessToken;
import org.exoplatform.moxtra.oauth2.AccessTokenRefreshListener;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class JCRMoxtraClientStore
extends BaseComponentPlugin
implements MoxtraClientStore {
    protected static final Log LOG = ExoLogger.getLogger(JCRMoxtraClientStore.class);
    protected final RepositoryService jcrService;
    protected final SessionProviderService jcrSessions;
    protected final NodeHierarchyCreator nodeCreator;

    public JCRMoxtraClientStore(RepositoryService jcrService, SessionProviderService jcrSessions, NodeHierarchyCreator nodeCreator) {
        this.jcrService = jcrService;
        this.jcrSessions = jcrSessions;
        this.nodeCreator = nodeCreator;
    }

    @Override
    public void saveUser(MoxtraClient client, MoxtraUser user) throws MoxtraStoreException {
    }

    @Override
    public MoxtraUser readUser(MoxtraClient client) throws MoxtraStoreException {
        return null;
    }

    @Override
    public void saveMeet(MoxtraClient client, MoxtraMeet meet) throws MoxtraStoreException {
        try {
            Node meetNode;
            Node meetsNode;
            Node userNode = this.userNode();
            try {
                meetsNode = JCR.getMeets(userNode);
            }
            catch (PathNotFoundException e) {
                meetsNode = JCR.addMeets(userNode);
            }
            if (meet.isNew()) {
                meetNode = meetsNode.addNode(meet.getBinderId());
                Node usersNode = JCR.addUsers(meetNode);
                for (MoxtraUser participant : meet.getUsers()) {
                    Node pnode = usersNode.addNode(participant.getId());
                    JCR.setId(pnode, participant.getId());
                    JCR.setName(pnode, participant.getName());
                    JCR.setEmail(pnode, participant.getEmail());
                }
                JCR.setAutoRecording(meetNode, meet.isAutoRecording());
            } else {
                Boolean autorec;
                meetNode = meetsNode.getNode(meet.getBinderId());
                Node usersNode = JCR.getUsers(meetNode);
                if (meet.hasUsersRemoved()) {
                    for (MoxtraUser removed : meet.getRemovedUsers()) {
                        usersNode.getNode(removed.getId()).remove();
                    }
                }
                if (meet.hasUsersAdded()) {
                    for (MoxtraUser participant : meet.getAddedUsers()) {
                        Node pnode = usersNode.addNode(participant.getId());
                        JCR.setId(pnode, participant.getId());
                        JCR.setName(pnode, participant.getName());
                        JCR.setEmail(pnode, participant.getEmail());
                    }
                }
                if ((autorec = meet.getAutoRecording()) != null) {
                    JCR.setAutoRecording(meetNode, autorec);
                }
            }
            JCR.setId(meetNode, meet.getBinderId());
            JCR.setName(meetNode, meet.getName());
            JCR.setAgenda(meetNode, meet.getAgenda());
            JCR.setStartMeetUrl(meetNode, meet.getStartMeetUrl());
            JCR.setStartTime(meetNode, meet.getStartTime());
            JCR.setEndTime(meetNode, meet.getEndTime());
            JCR.setCreatedTime(meetNode, meet.getCreatedTime());
            JCR.setUpdatedTime(meetNode, meet.getUpdatedTime());
            JCR.setRevision(meetNode, meet.getRevision());
            JCR.setSessionKey(meetNode, meet.getSessionKey());
            if (meetNode.isNew()) {
                meetsNode.save();
            } else {
                meetNode.save();
            }
        }
        catch (RepositoryException e) {
            throw new MoxtraStoreException("Error saving Moxtra meet " + meet.getName(), e);
        }
        catch (Exception e) {
            throw new MoxtraStoreException("Error saving Moxtra meet " + meet.getName(), e);
        }
    }

    @Override
    public MoxtraMeet readMeet(MoxtraClient client) throws MoxtraStoreException {
        return null;
    }

    @Override
    public void save(MoxtraClient client) throws MoxtraStoreException {
        try {
            Node userNode = this.userNode();
            if (!JCR.isUserStore(userNode)) {
                JCR.addUserStore(userNode);
                userNode.save();
            }
            this.saveListenToken(userNode, client);
        }
        catch (Exception e) {
            throw new MoxtraStoreException("Error saving Moxtra client", e);
        }
    }

    @Override
    public boolean load(MoxtraClient client) throws MoxtraStoreException {
        try {
            Node userNode = this.userNode();
            if (JCR.isUserStore(userNode)) {
                return this.loadListenToken(userNode, client);
            }
            return false;
        }
        catch (Exception e) {
            throw new MoxtraStoreException("Error loading Moxtra client", e);
        }
    }

    protected Node userNode() throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        return this.nodeCreator.getUserNode(this.jcrSessions.getSystemSessionProvider(null), currentUser);
    }

    protected void saveListenToken(Node userNode, MoxtraClient client) throws RepositoryException {
        Node tokenNode;
        MoxtraClientInitializer cli = new MoxtraClientInitializer(client);
        try {
            tokenNode = JCR.getOAuth2AccessToken(userNode);
        }
        catch (PathNotFoundException e) {
            tokenNode = JCR.addOAuth2AccessToken(userNode);
        }
        AccessToken accesstToken = cli.getClientToken();
        if (accesstToken.isInitialized()) {
            this.persistToken(tokenNode, accesstToken);
            if (tokenNode.isNew()) {
                userNode.save();
            } else {
                tokenNode.save();
            }
        } else if (tokenNode.isNew()) {
            userNode.save();
        }
        accesstToken.addListener(new ClientListener(tokenNode.getUUID()), true);
    }

    protected void persistToken(Node tokenNode, AccessToken accesstToken) throws RepositoryException {
        JCR.setAccessToken(tokenNode, accesstToken.getAccessToken());
        String refreshToken = accesstToken.getRefreshToken();
        if (refreshToken != null) {
            JCR.setRefreshToken(tokenNode, refreshToken);
        }
        JCR.setExpirationTime(tokenNode, accesstToken.getExpirationTime());
        String scope = accesstToken.getScope();
        if (scope != null) {
            JCR.setScope(tokenNode, scope);
        }
        Date now = Calendar.getInstance().getTime();
        try {
            JCR.getCreatedTime(tokenNode);
        }
        catch (PathNotFoundException e) {
            JCR.setCreatedTime(tokenNode, now);
        }
        JCR.setUpdatedTime(tokenNode, now);
    }

    protected boolean loadListenToken(Node userNode, MoxtraClient client) throws RepositoryException {
        try {
            Node tokenNode = JCR.getOAuth2AccessToken(userNode);
            MoxtraClientInitializer cli = new MoxtraClientInitializer(client);
            AccessToken savedToken = this.readToken(tokenNode);
            cli.initClientToken(savedToken);
            cli.getClientToken().addListener(new ClientListener(tokenNode.getUUID()), false);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected AccessToken readToken(Node tokenNode) throws RepositoryException {
        String scope;
        String refreshToken;
        AccessToken newToken = AccessToken.newToken();
        try {
            refreshToken = JCR.getRefreshToken(tokenNode).getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        try {
            scope = JCR.getScope(tokenNode).getString();
        }
        catch (PathNotFoundException e) {
            scope = null;
        }
        newToken.load(JCR.getAccessToken(tokenNode).getString(), refreshToken, JCR.getExpirationTime(tokenNode).getDate(), scope);
        return newToken;
    }

    protected class ClientListener
    implements AccessTokenRefreshListener {
        protected final String tokenNodeUUID;

        protected ClientListener(String tokenNodeUUID) {
            this.tokenNodeUUID = tokenNodeUUID;
        }

        @Override
        public void onTokenRefresh(AccessToken token) {
            if (token.isInitialized()) {
                try {
                    SessionProvider sp = JCRMoxtraClientStore.this.jcrSessions.getSystemSessionProvider(null);
                    ManageableRepository currentRepo = JCRMoxtraClientStore.this.jcrService.getCurrentRepository();
                    Session userSession = sp.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
                    Node tokenNode = userSession.getNodeByUUID(this.tokenNodeUUID);
                    JCRMoxtraClientStore.this.persistToken(tokenNode, token);
                    tokenNode.save();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Error saving client token", (Throwable)e);
                }
            }
        }
    }
}

