/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.rest;

import java.net.URI;
import java.util.Calendar;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.moxtra.Moxtra;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.MoxtraService;
import org.exoplatform.moxtra.NotFoundException;
import org.exoplatform.moxtra.client.MoxtraClient;
import org.exoplatform.moxtra.client.MoxtraClientException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.rest.ErrorInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/moxtra/meet")
@Produces(value={"application/json"})
public class MeetService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(MeetService.class);
    protected final MoxtraService moxtra;

    public MeetService(MoxtraService moxtra) {
        this.moxtra = moxtra;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/{sessionKey}")
    public Response get(@Context UriInfo uriInfo, @PathParam(value="sessionKey") String sessionKey) {
        try {
            if (sessionKey != null) {
                return Response.ok().entity((Object)this.moxtra.getClient().getMeet(sessionKey)).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Meet session_key cannot be null")).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Meet not found " + sessionKey)).build();
        }
        catch (MoxtraClientException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error getting meet " + sessionKey)).build();
        }
        catch (MoxtraException e) {
            LOG.error((Object)("Error reading meet " + sessionKey), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading meet")).build();
        }
        catch (OAuthSystemException e) {
            LOG.error((Object)("Access error for reading meet " + sessionKey), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Access error for reading meet")).build();
        }
        catch (OAuthProblemException e) {
            LOG.warn((Object)("Access problem while reading meet " + sessionKey), (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Acces problem while reading meet")).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/{sessionKey}")
    public Response delete(@Context UriInfo uriInfo, @PathParam(value="sessionKey") String sessionKey) {
        try {
            if (sessionKey != null) {
                MoxtraClient client = this.moxtra.getClient();
                MoxtraMeet meet = client.getMeet(sessionKey);
                client.deleteMeet(meet);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Meet session_key cannot be null")).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Meet not found " + sessionKey)).build();
        }
        catch (MoxtraClientException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error deleting meet " + sessionKey)).build();
        }
        catch (MoxtraException e) {
            LOG.error((Object)("Error deleting meet " + sessionKey), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error deleting meet")).build();
        }
        catch (OAuthSystemException e) {
            LOG.error((Object)("Access error for deleting meet " + sessionKey), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Access error for deleting meet")).build();
        }
        catch (OAuthProblemException e) {
            LOG.warn((Object)("Access problem while deleting meet " + sessionKey), (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Acces problem while deleting meet")).build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    public Response createNew(@Context UriInfo uriInfo, @FormParam(value="name") String name, @FormParam(value="agenda") @DefaultValue(value="") String agenda, @FormParam(value="startTime") String startTimeMs, @FormParam(value="endTime") String endTimeMs, @FormParam(value="autoRecording") @DefaultValue(value="false") String autoRecording) {
        try {
            if (name != null) {
                if (startTimeMs != null && endTimeMs != null) {
                    MoxtraMeet meet = new MoxtraMeet().editor();
                    meet.editName(name);
                    meet.editAgenda(agenda);
                    try {
                        meet.editStartTime(Moxtra.getDate(Long.parseLong(startTimeMs)));
                    }
                    catch (NumberFormatException e) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error parsing meet start date " + startTimeMs)).build();
                    }
                    try {
                        meet.editEndTime(Moxtra.getDate(Long.parseLong(endTimeMs)));
                    }
                    catch (NumberFormatException e) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error parsing meet end date " + endTimeMs)).build();
                    }
                    meet.editAutoRecording(Boolean.parseBoolean(autoRecording));
                    MoxtraClient client = this.moxtra.getClient();
                    client.createMeet(meet);
                    client.refreshMeet(meet);
                    return Response.created((URI)uriInfo.getRequestUri()).entity((Object)meet).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Meet time(s) required")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Meet name required")).build();
        }
        catch (MoxtraClientException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error creating meet " + name)).build();
        }
        catch (MoxtraException e) {
            LOG.error((Object)("Error creating meet " + name), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error creating meet")).build();
        }
        catch (OAuthSystemException e) {
            LOG.error((Object)("Access error for creating meet " + name), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Access error for creating meet")).build();
        }
        catch (OAuthProblemException e) {
            LOG.warn((Object)("Access problem while creating meet " + name), (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Acces problem while creating meet " + name)).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/find")
    public Response find(@Context UriInfo uriInfo, @QueryParam(value="invitee") String inviteeEmail) {
        try {
            if (inviteeEmail != null) {
                MoxtraClient client = this.moxtra.getClient();
                Calendar from = Moxtra.getCalendar();
                from.add(12, -60);
                for (MoxtraMeet meet : client.getMeets(from.getTime(), 1)) {
                    MoxtraUser hoster;
                    List<MoxtraUser> users;
                    MoxtraUser invited;
                    if (!meet.canStart() || (invited = this.findUser(users = meet.getUsers(), inviteeEmail)) == null || users.size() != 2 || (hoster = meet.getHostUser()).equals(invited) || !meet.hasUser(hoster)) continue;
                    return Response.ok().entity((Object)meet).build();
                }
            }
            return Response.noContent().build();
        }
        catch (MoxtraClientException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error searching meets with invitee " + inviteeEmail)).build();
        }
        catch (MoxtraException e) {
            LOG.error((Object)("Error searching meets with invitee " + inviteeEmail), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading meet")).build();
        }
        catch (OAuthSystemException e) {
            LOG.error((Object)("Access error for searching meets with invitee " + inviteeEmail), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Access error for reading meet")).build();
        }
        catch (OAuthProblemException e) {
            LOG.warn((Object)("Access problem while searching meets with invitee " + inviteeEmail), (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Acces problem while searching meet")).build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/{sessionKey}/inviteusers")
    public Response inviteUsers(@Context UriInfo uriInfo, @PathParam(value="sessionKey") String sessionKey, @FormParam(value="message") String message, @FormParam(value="users[]") List<String> users) {
        try {
            if (sessionKey != null) {
                if (users != null && users.size() > 0) {
                    MoxtraClient client = this.moxtra.getClient();
                    try {
                        MoxtraMeet meet = client.getMeet(sessionKey).editor();
                        for (String email : users) {
                            meet.addUser(new MoxtraUser(email));
                        }
                        client.inviteMeetUsers(meet);
                        return Response.ok().entity((Object)meet).build();
                    }
                    catch (MoxtraClientException e) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Error inviting user(s) to meet")).build();
                    }
                    catch (OAuthSystemException e) {
                        LOG.error((Object)("Access error for inviting users to meet " + sessionKey), (Throwable)e);
                        return Response.serverError().entity((Object)ErrorInfo.serverError("Access error for inviting users")).build();
                    }
                    catch (OAuthProblemException e) {
                        LOG.warn((Object)("Access problem while inviting users to meet " + sessionKey), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Access problem while inviting users to meet")).build();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("> Empty users in meet invitation - do nothing: " + users));
                }
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Meet's session key required")).build();
        }
        catch (MoxtraException e) {
            LOG.error((Object)("Error inviting users to meet " + sessionKey), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error inviting users")).build();
        }
    }

    protected MoxtraUser findUser(List<MoxtraUser> users, String email) {
        for (MoxtraUser user : users) {
            if (!email.equals(user.getEmail())) continue;
            return user;
        }
        return null;
    }
}

