/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.rest;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.moxtra.MoxtraService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/moxtra/login")
@Produces(value={"text/html"})
public class OAuthCodeAuthenticator
implements ResourceContainer {
    public static final String CLIENT_CODE_COOKIE = "moxtra-client-code";
    public static final int CLIENT_COOKIE_EXPIRE = 20;
    public static final String CLIENT_ERROR_COOKIE = "moxtra-client-error";
    public static final String CLIENT_CODE_AUTHORIZED = "authorized";
    protected static final Log LOG = ExoLogger.getLogger(OAuthCodeAuthenticator.class);
    protected static final String EMPTY = "".intern();
    protected final MoxtraService moxtra;

    public OAuthCodeAuthenticator(MoxtraService moxtra) {
        this.moxtra = moxtra;
    }

    @GET
    public Response auth(@Context UriInfo uriInfo, @QueryParam(value="code") String code, @CookieParam(value="JSESSIONID") Cookie jsessionsId, @CookieParam(value="JSESSIONIDSSO") Cookie jsessionsIdSSO) {
        try {
            this.moxtra.getClient().authorizer().authorize(code);
            return Response.ok().cookie(new NewCookie[]{new NewCookie(CLIENT_CODE_COOKIE, CLIENT_CODE_AUTHORIZED, "/", uriInfo.getRequestUri().getHost(), EMPTY, 20, false)}).cookie(new NewCookie[]{new NewCookie(CLIENT_ERROR_COOKIE, "OAuth2 system error", "/", uriInfo.getRequestUri().getHost(), EMPTY, 0, false)}).entity((Object)"<!doctype html><html><head><script type='text/javascript'> window.close();</script></head><body><div id='messageString'>Connecting to Moxtra...</div></body></html>").build();
        }
        catch (OAuthSystemException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"OAuth2 system error", (Throwable)e);
            }
            return Response.serverError().cookie(new NewCookie[]{new NewCookie(CLIENT_ERROR_COOKIE, "OAuth2 system error", "/", uriInfo.getRequestUri().getHost(), EMPTY, 20, false)}).cookie(new NewCookie[]{new NewCookie(CLIENT_CODE_COOKIE, CLIENT_CODE_AUTHORIZED, "/", uriInfo.getRequestUri().getHost(), EMPTY, 0, false)}).entity((Object)("System error. " + e.getMessage())).build();
        }
        catch (OAuthProblemException e) {
            String msg;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"OAuth2 problem", (Throwable)e);
            }
            if ((msg = e.getMessage()) != null && msg.indexOf("invalid_request") >= 0) {
                Throwable cause = e.getCause();
                msg = "Invalid request. " + cause.getMessage();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cookie(new NewCookie[]{new NewCookie(CLIENT_ERROR_COOKIE, "OAuth2 problem", "/", uriInfo.getRequestUri().getHost(), EMPTY, 20, false)}).cookie(new NewCookie[]{new NewCookie(CLIENT_CODE_COOKIE, CLIENT_CODE_AUTHORIZED, "/", uriInfo.getRequestUri().getHost(), EMPTY, 0, false)}).entity((Object)("Authorization problem. " + msg)).build();
        }
    }
}

