/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.calendar.MoxtraCalendarException;
import org.exoplatform.moxtra.calendar.MoxtraCalendarService;
import org.exoplatform.moxtra.calendar.MoxtraMeetNotFoundException;
import org.exoplatform.moxtra.calendar.webui.UICalendarView;
import org.exoplatform.moxtra.calendar.webui.UIEmeetingTab;
import org.exoplatform.moxtra.calendar.webui.UIEventForm;
import org.exoplatform.moxtra.calendar.webui.UIPopupWindow;
import org.exoplatform.moxtra.client.MoxtraAuthenticationException;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.webui.MoxtraApplication;
import org.exoplatform.moxtra.webui.MoxtraNotActivatedException;
import org.exoplatform.moxtra.webui.MoxtraNotInitializedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

public class MoxtraCalendarApplication
implements MoxtraApplication {
    public static final String QUICK_ADD_EVENT_POPUP_ID = "UIQuickAddEventPopupWindow".intern();
    public static final String QUICK_ADD_TASK_POPUP_ID = "UIQuickAddTaskPopupWindow".intern();
    public static final String QUICK_ADD_EVENT_FORM_ID = "UIQuickAddEvent".intern();
    public static final String QUICK_ADD_TASK_FORM_ID = "UIQuickAddTask".intern();
    public static final Log LOG = ExoLogger.getLogger(MoxtraCalendarApplication.class);
    protected static final String COLON = ":".intern();
    protected final ThreadLocal<UIApplication> uiApp = new ThreadLocal();
    protected final ThreadLocal<UIForm> requestForm = new ThreadLocal();
    protected final ThreadLocal<UIContainer> requestViewContainer = new ThreadLocal();
    protected final Map<UIComponent, MoxtraMeet> meets = new ConcurrentHashMap<UIComponent, MoxtraMeet>();
    @Deprecated
    protected final Map<String, SoftReference<MoxtraMeet>> eventMeets = new ConcurrentHashMap<String, SoftReference<MoxtraMeet>>();
    protected final Set<Component> mergedConfigs = new HashSet<Component>();
    protected MoxtraCalendarService moxtra;

    public void init() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.moxtra = (MoxtraCalendarService)container.getComponentInstanceOfType(MoxtraCalendarService.class);
    }

    public boolean isAuthorized() throws MoxtraNotInitializedException {
        return this.moxtra().isAuthorized();
    }

    public String getAuthorizationLink() throws MoxtraNotInitializedException, OAuthSystemException, MoxtraConfigurationException {
        return this.moxtra().getOAuth2Link();
    }

    @Deprecated
    public void activateForm(UIForm form) {
        if (this.isQuickAddForm((UIComponent)form)) {
            this.initQuickAddForm(form);
        } else {
            this.initEventForm(form);
        }
    }

    public void activate(UIApplication uiApp) {
        org.exoplatform.webui.core.UIPopupWindow uiPopupWindow;
        UIContainer uiPopupAction;
        UIContainer viewContainer;
        this.uiApp.set(uiApp);
        UIContainer calContainer = (UIContainer)this.findComponent((UIContainer)uiApp, "UICalendarWorkingContainer");
        if (calContainer != null && (viewContainer = (UIContainer)this.findComponent((UIContainer)uiApp, "UICalendarViewContainer")) != null) {
            Object renderedComp;
            this.requestViewContainer.set(viewContainer);
            try {
                renderedComp = (UIComponent)MethodUtils.invokeMethod((Object)viewContainer, (String)"getRenderedChild", null);
            }
            catch (Exception e) {
                renderedComp = this.findRenderedChildByInterface(viewContainer, "CalendarView");
            }
            if (renderedComp != null) {
                UIForm listForm;
                if (renderedComp instanceof UIForm) {
                    this.initViewForm((UIForm)renderedComp);
                } else if (renderedComp instanceof UIContainer && (listForm = (UIForm)this.findComponent((UIContainer)renderedComp, "UIListView")) != null && listForm.isRendered()) {
                    this.initViewForm(listForm);
                }
            }
        }
        if ((uiPopupAction = (UIContainer)this.findComponent((UIContainer)uiApp, "UIPopupAction")) != null && (uiPopupWindow = (org.exoplatform.webui.core.UIPopupWindow)uiPopupAction.getChild(org.exoplatform.webui.core.UIPopupWindow.class)) != null) {
            UIContainer uiPopupContainer = (UIContainer)uiPopupWindow.getUIComponent();
            if (uiPopupWindow instanceof UIPopupWindow) {
                if (uiPopupContainer != null) {
                    this.initEventFormContainer(uiPopupContainer);
                }
            } else {
                try {
                    if (uiPopupContainer != null) {
                        this.initEventFormContainer(uiPopupContainer);
                    } else {
                        UIPopupWindow newPopupWindow = (UIPopupWindow)uiPopupAction.createUIComponent(UIPopupWindow.class, null, null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(">> activate: " + (Object)((Object)newPopupWindow)));
                        }
                        newPopupWindow.initMoxtra(this);
                        newPopupWindow.setId(uiPopupWindow.getId());
                        newPopupWindow.setRendered(uiPopupWindow.isRendered());
                        uiPopupAction.removeChild(org.exoplatform.webui.core.UIPopupWindow.class);
                        uiPopupAction.addChild((UIComponent)newPopupWindow);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error creating new popup window in Calendar app", (Throwable)e);
                }
            }
        }
    }

    public void reset() {
        UIComponent form = (UIComponent)this.requestForm.get();
        if (form != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<< reset: " + form));
            }
            this.requestForm.remove();
            this.meets.remove(form);
        }
        this.requestViewContainer.remove();
    }

    public void initEventFormContainer(UIContainer formContainer) {
        UIForm form = (UIForm)this.findComponent(formContainer, "UIEventForm");
        if (form != null) {
            this.initEventForm(form);
        }
    }

    protected void initEventForm(UIForm form) {
        if (form.getId().equals("UIEventForm")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">>> initEventForm: " + form));
            }
            try {
                if (form.getChildById(UIEmeetingTab.class.getSimpleName()) == null) {
                    UIEmeetingTab moxtraTab = (UIEmeetingTab)form.createUIComponent(UIEmeetingTab.class, null, null);
                    this.initContext(form);
                    this.initEventMeet(form);
                    form.addChild((UIComponent)moxtraTab);
                    moxtraTab.initMoxtra(this);
                    this.mergeConfigs(form.getComponentConfig(), UIEventForm.class);
                } else {
                    this.initContext(form);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error creating Moxtra tab in Calendar event form " + form), (Throwable)e);
            }
        }
    }

    protected void initViewForm(UIForm form) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> initViewForm: " + form));
        }
        try {
            MoxtraMeet meet;
            String eventId;
            String objId = WebuiRequestContext.getCurrentInstance().getRequestParameter("objectId");
            if (objId != null && objId.startsWith("Event")) {
                eventId = objId;
            } else {
                eventId = WebuiRequestContext.getCurrentInstance().getRequestParameter(UICalendarView.EVENTID);
                if (eventId == null && (eventId = (String)MethodUtils.invokeMethod((Object)form, (String)"getLastUpdatedEventId", null)) == null) {
                    eventId = (String)FieldUtils.readField((Object)form, (String)"singleDeletedEventId", (boolean)true);
                }
            }
            CalendarEvent event = eventId != null ? this.moxtra.getEvent(eventId) : (CalendarEvent)MethodUtils.invokeMethod((Object)form, (String)"getcurrentOccurrence", null);
            if (event != null && (meet = this.moxtra().getMeet(event)) != null) {
                meet = meet.editor();
                this.requestForm.set(form);
                this.meets.put((UIComponent)form, meet);
                this.moxtra().initContext(this);
                this.mergeConfigs(form.getComponentConfig(), UICalendarView.class);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error initializing Moxtra meet in Calendar view " + form), (Throwable)e);
        }
    }

    protected void initEventMeet(UIForm form) throws MoxtraCalendarException {
        MoxtraMeet meet = this.findFormMeet(form);
        if (meet != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">>>> initEventMeet for " + form + " " + meet + " (" + meet.getSessionKey() + ") " + meet.getName()));
            }
            this.meets.put((UIComponent)form, meet);
        }
    }

    protected void initQuickAddMeet() {
    }

    @Deprecated
    protected void initQuickAddForm(UIForm form) {
        block0: {
            if (!this.isQuickAddForm((UIComponent)form) || !LOG.isDebugEnabled()) break block0;
            LOG.debug((Object)(">> initQuickAddForm: " + form));
        }
    }

    public void deactivate(UIApplication uiApp) {
        this.uiApp.remove();
        this.requestForm.remove();
    }

    public MoxtraMeet enableMeet() throws MoxtraNotActivatedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> enableMeet: " + this.uiApp.get()));
        }
        MoxtraCalendarService moxtra = this.moxtra();
        MoxtraMeet meet = this.meet();
        if (meet == null) {
            meet = moxtra.newMeet();
            this.meets.put((UIComponent)this.form(), meet);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">>> enableMeet: " + this.uiApp.get() + " new meet " + meet));
            }
        } else if (meet.hasDeleted()) {
            meet.undelete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">>> enableMeet: " + this.uiApp.get() + " undeleted " + meet + " (" + meet.getSessionKey() + ") " + meet.getName()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> enableMeet: " + this.uiApp.get() + " already enabled " + meet + " (" + meet.getSessionKey() + ") " + meet.getName()));
        }
        return meet;
    }

    public MoxtraMeet disableMeet() throws MoxtraNotActivatedException {
        MoxtraMeet meet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> disableMeet: " + this.uiApp.get()));
        }
        if ((meet = this.meet()) != null && !meet.isNew()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">>> disableMeet: " + this.form() + " delete " + meet));
            }
            meet.delete();
            return meet;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> disableMeet: " + this.form() + " clean " + meet));
        }
        this.meets.remove(this.form());
        return null;
    }

    public MoxtraMeet getMeet() throws MoxtraNotActivatedException, MoxtraMeetNotFoundException {
        MoxtraMeet meet = this.meet();
        if (meet != null) {
            return meet;
        }
        throw new MoxtraMeetNotFoundException("Meet not found for " + this.uiApp.get());
    }

    public boolean hasMeet() throws MoxtraNotActivatedException {
        MoxtraMeet meet = this.meet();
        return meet != null;
    }

    public boolean isMeetEnabled() throws MoxtraNotActivatedException {
        MoxtraMeet meet = this.meet();
        return meet != null ? !meet.hasDeleted() : false;
    }

    public boolean isActivated() {
        return this.requestForm.get() != null;
    }

    public boolean isInitialized() {
        return this.moxtra != null;
    }

    public MoxtraUser getUser() throws MoxtraCalendarException, MoxtraException {
        return this.moxtra().getUser();
    }

    public CalendarSetting getCalendarSetting() throws MoxtraCalendarException, Exception {
        return this.moxtra().getCalendarSetting();
    }

    public List<MoxtraUser> getUserContacts() throws MoxtraCalendarException, MoxtraAuthenticationException, MoxtraException, MoxtraConfigurationException {
        return this.moxtra().getContacts();
    }

    public void saveMeet() throws Exception {
        Set<String> eventIds = this.getEventIds();
        if (eventIds.size() > 0) {
            for (String eventId : eventIds) {
                String calendarId = this.getEventCalendarId();
                CalendarEvent event = this.moxtra().getEvent(eventId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> saveMeet: event " + eventId + " \"" + event.getSummary() + "\"" + (calendarId != null ? " in " + calendarId : "")));
                }
                this.moxtra().saveMeet(calendarId, event);
            }
        } else {
            LOG.error((Object)"Error saving meet: cannot find event id");
            throw new MoxtraCalendarException("Error saving meet: cannot find event id");
        }
    }

    protected void initContext(UIForm form) throws MoxtraCalendarException, MoxtraException, MoxtraConfigurationException {
        this.requestForm.set(form);
        this.moxtra().initContext(this);
    }

    protected <T extends UIComponent> T findComponent(UIContainer container, String typeName) {
        Object child = container.findComponentById(typeName);
        if (child == null) {
            for (UIComponent cc : container.getChildren()) {
                if (cc.getClass().getSimpleName().equals(typeName)) {
                    child = cc;
                    break;
                }
                if (!(cc instanceof UIContainer) || (child = this.findComponent((UIContainer)cc, typeName)) == null) continue;
                break;
            }
        }
        return (T)child;
    }

    protected <T extends UIComponent> T findChildBySuperType(UIContainer container, String superTypeName) {
        List<T> childs = this.findChildsBySuperType(container, superTypeName, false);
        UIComponent child = null;
        for (UIComponent cc : childs) {
            if (child != null) {
                if (!cc.isRendered()) continue;
                child = cc;
                break;
            }
            child = cc;
            if (!cc.isRendered()) continue;
            break;
        }
        return (T)child;
    }

    protected <T extends UIComponent> T findRenderedChildBySuperType(UIContainer container, String superTypeName) {
        List<T> childs = this.findChildsBySuperType(container, superTypeName, false);
        for (UIComponent cc : childs) {
            if (!cc.isRendered()) continue;
            return (T)cc;
        }
        return null;
    }

    protected <T extends UIComponent> List<T> findChildsBySuperType(UIContainer container, String superTypeName, boolean deep) {
        ArrayList<Object> childs = new ArrayList<Object>();
        for (UIComponent cc : container.getChildren()) {
            Class<?> superType = cc.getClass().getSuperclass();
            if (superType == null || !superType.getSimpleName().equals(superTypeName)) continue;
            childs.add(cc);
            if (!deep || !(cc instanceof UIContainer)) continue;
            List<T> ccChilds = this.findChildsBySuperType((UIContainer)cc, superTypeName, deep);
            childs.addAll(ccChilds);
        }
        return childs;
    }

    protected <T extends UIComponent> T findRenderedChildByInterface(UIContainer container, String interfaceName) {
        List<T> childs = this.findChildsByInterface(container, interfaceName, false);
        for (UIComponent cc : childs) {
            if (!cc.isRendered()) continue;
            return (T)cc;
        }
        return null;
    }

    protected <T extends UIComponent> List<T> findChildsByInterface(UIContainer container, String interfaceName, boolean deep) {
        ArrayList<Object> childs = new ArrayList<Object>();
        for (UIComponent cc : container.getChildren()) {
            for (Class<?> interfaceType : cc.getClass().getInterfaces()) {
                if (!interfaceType.getSimpleName().equals(interfaceName)) continue;
                childs.add(cc);
                if (!deep || !(cc instanceof UIContainer)) continue;
                List<T> ccChilds = this.findChildsByInterface((UIContainer)cc, interfaceName, deep);
                childs.addAll(ccChilds);
            }
        }
        return childs;
    }

    protected String getEventCalendarId() throws MoxtraCalendarException {
        block5: {
            UIFormInputWithActions eventDetailTab;
            UIForm form = this.requestForm.get();
            if (form != null && (eventDetailTab = (UIFormInputWithActions)form.getChildById("eventDetail")) != null) {
                try {
                    String value = (String)((UIFormStringInput)eventDetailTab.findComponentById("calendar")).getValue();
                    if (value != null && value.length() > 0) {
                        String[] values = (value = value.trim()).split(COLON);
                        if (values.length > 0) {
                            return values[1];
                        }
                        return value;
                    }
                }
                catch (NullPointerException e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)("Error searching for calendar conponent in " + form), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String getCalendarType() throws MoxtraCalendarException {
        block4: {
            UIFormInputWithActions eventDetailTab;
            UIForm form = this.requestForm.get();
            if (form != null && (eventDetailTab = (UIFormInputWithActions)form.getChildById("eventDetail")) != null) {
                try {
                    String[] values;
                    String value = (String)((UIFormStringInput)eventDetailTab.findComponentById("calendar")).getValue();
                    if (value != null && value.length() > 0 && (values = (value = value.trim()).split(COLON)).length > 0) {
                        return values[0];
                    }
                }
                catch (NullPointerException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)("Error searching for calendar conponent in " + form), (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<String> getEventIds() {
        LinkedHashSet<String> eventIds = new LinkedHashSet<String>();
        UIContainer viewContainer = this.requestViewContainer.get();
        if (viewContainer != null) {
            void var3_5;
            try {
                UIComponent uIComponent = (UIComponent)MethodUtils.invokeMethod((Object)viewContainer, (String)"getRenderedChild", null);
            }
            catch (Exception e) {
                Object t = this.findRenderedChildByInterface(viewContainer, "CalendarView");
            }
            String eventId = null;
            if (var3_5 != null) {
                try {
                    eventId = (String)MethodUtils.invokeMethod((Object)var3_5, (String)"getLastUpdatedEventId", null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (eventId != null) {
                eventIds.add(eventId);
                return eventIds;
            } else {
                if (var3_5 == null || !var3_5.isRendered()) return eventIds;
                try {
                    List events = (List)MethodUtils.invokeMethod((Object)var3_5, (String)"getSelectedEvents", null);
                    if (events == null) return eventIds;
                    for (CalendarEvent ce : events) {
                        eventIds.add(ce.getId());
                    }
                    return eventIds;
                }
                catch (Exception e) {
                    return eventIds;
                }
            }
        }
        if (!LOG.isDebugEnabled()) return eventIds;
        LOG.debug((Object)("<<< requestViewContainer not set for " + this.requestForm.get()));
        return eventIds;
    }

    @Deprecated
    protected String getQuickAddCalendarId(UIForm quickAddForm) throws MoxtraCalendarException {
        Object res = ((UIFormInputBase)quickAddForm.findComponentById("calendar")).getValue();
        if (res != null) {
            if (res instanceof String) {
                return (String)res;
            }
            throw new MoxtraCalendarException("Unexpected object type returned from getEventCalendar() on " + quickAddForm.getClass().getName());
        }
        return null;
    }

    protected MoxtraCalendarService moxtra() throws MoxtraNotInitializedException {
        MoxtraCalendarService moxtra = this.moxtra;
        if (moxtra != null) {
            return moxtra;
        }
        throw new MoxtraNotInitializedException("Moxtra application not initialized");
    }

    protected UIForm form() throws MoxtraNotActivatedException {
        UIForm form = this.requestForm.get();
        if (form != null) {
            return form;
        }
        throw new MoxtraNotActivatedException("Moxtra application not activated");
    }

    protected MoxtraMeet findFormMeet(UIForm form) throws MoxtraNotInitializedException, MoxtraCalendarException {
        try {
            CalendarEvent event = (CalendarEvent)FieldUtils.readField((Object)form, (String)"calendarEvent_", (boolean)true);
            if (event != null) {
                MoxtraMeet meet = this.moxtra().getMeet(event);
                if (meet != null) {
                    return meet.editor();
                }
                return null;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new MoxtraCalendarException("Cannot find calendar event in " + form, e);
        }
    }

    protected MoxtraMeet meet() throws MoxtraNotActivatedException {
        MoxtraMeet meet = this.meets.get(this.form());
        return meet;
    }

    protected boolean isQuickAddForm(UIComponent form) {
        return QUICK_ADD_EVENT_FORM_ID.equals(form.getId()) || QUICK_ADD_TASK_FORM_ID.equals(form.getId());
    }

    public void mergeConfigs(Component original, Class<? extends UIComponent> clazz) throws Exception {
        if (!this.mergedConfigs.contains(original)) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            WebuiApplication webuiApp = (WebuiApplication)context.getApplication();
            Component extension = webuiApp.getConfigurationManager().getComponentConfig(clazz, null);
            LinkedHashSet extEvents = new LinkedHashSet(extension.getEvents());
            List events = original.getEvents();
            for (Event oe : events) {
                String eventName = oe.getName();
                Iterator eeiter = extEvents.iterator();
                while (eeiter.hasNext()) {
                    Event ee = (Event)eeiter.next();
                    if (!eventName.equals(ee.getName())) continue;
                    LinkedHashSet names = new LinkedHashSet();
                    names.addAll(oe.getListeners());
                    names.addAll(ee.getListeners());
                    oe.setListeners(new ArrayList(names));
                    original.getUIComponentEventConfig(eventName);
                    extension.getUIComponentEventConfig(eventName);
                    LinkedHashSet listeners = new LinkedHashSet();
                    listeners.addAll(oe.getCachedEventListeners());
                    listeners.addAll(ee.getCachedEventListeners());
                    oe.setCachedEventListeners(new ArrayList(listeners));
                    eeiter.remove();
                }
            }
            if (extEvents.size() > 0) {
                events.addAll(extEvents);
                FieldUtils.writeDeclaredField((Object)original, (String)"eventMap", null, (boolean)true);
            }
            if (extension.getTemplate() != null && extension.getTemplate().length() > 0) {
                FieldUtils.writeDeclaredField((Object)original, (String)"template", (Object)extension.getTemplate(), (boolean)true);
            }
            this.mergedConfigs.add(original);
        }
    }

    @Deprecated
    protected MoxtraMeet getEventMeet(String eventId) {
        MoxtraMeet meet;
        SoftReference<MoxtraMeet> mref = this.eventMeets.get(eventId);
        if (mref != null && (meet = mref.get()) != null) {
            return meet;
        }
        return null;
    }
}

