/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar.webui;

import org.apache.commons.lang.reflect.FieldUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.moxtra.calendar.MoxtraCalendarService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(events={@EventConfig(listeners={ConfirmCloseActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={MoveEventActionListener.class})})
public class UICalendarView
extends UIForm {
    public static final String CALENDARID = "calendarId".intern();
    public static final String CALTYPE = "calType".intern();
    public static final String EVENTID = "eventId".intern();
    public static final String START_TIME = "startTime".intern();
    public static final String FINISH_TIME = "finishTime".intern();
    private static final Log LOG = ExoLogger.getExoLogger(UICalendarView.class);

    public static class MoveEventActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiCalendarView = (UIForm)event.getSource();
            WebuiRequestContext context = event.getRequestContext();
            String eventIds = context.getRequestParameter("objectId");
            String calendarId = context.getRequestParameter(CALENDARID);
            String calendarType = event.getRequestContext().getRequestParameter(CALTYPE);
            if (calendarId != null && calendarType != null && eventIds != null && String.valueOf(0).equals(calendarType)) {
                MoxtraCalendarService moxtra = (MoxtraCalendarService)uiCalendarView.getApplicationComponent(MoxtraCalendarService.class);
                for (String eventId : eventIds.split(",")) {
                    CalendarEvent calendarEvent = moxtra.getEvent(eventId = eventId.trim());
                    if (calendarEvent != null) {
                        moxtra.saveMeet(calendarId, calendarEvent);
                        continue;
                    }
                    LOG.warn((Object)("Cannot find moved event " + eventId + " in calendar " + calendarId));
                }
            }
        }
    }

    public static class UpdateEventActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiCalendarView = (UIForm)event.getSource();
            WebuiRequestContext context = event.getRequestContext();
            String eventId = context.getRequestParameter("objectId");
            String calendarId = context.getRequestParameter(eventId + CALENDARID);
            String calendarType = context.getRequestParameter(eventId + CALTYPE);
            if (eventId == null || !eventId.startsWith("Event")) {
                eventId = context.getRequestParameter(EVENTID);
                calendarId = context.getRequestParameter(CALENDARID);
                calendarType = context.getRequestParameter(CALTYPE);
            }
            if (calendarId != null && calendarType != null && eventId != null && String.valueOf(0).equals(calendarType)) {
                MoxtraCalendarService moxtra = (MoxtraCalendarService)uiCalendarView.getApplicationComponent(MoxtraCalendarService.class);
                CalendarEvent calendarEvent = moxtra.getEvent(eventId);
                if (calendarEvent != null) {
                    moxtra.saveMeet(calendarId, calendarEvent);
                } else {
                    LOG.warn((Object)("Cannot find updated event " + eventId + " in calendar " + calendarId));
                }
            }
        }
    }

    public static class ConfirmCloseActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiCalendarView = (UIForm)event.getSource();
            String calendarType = (String)FieldUtils.readField((Object)uiCalendarView, (String)"singleDeletedEventType", (boolean)true);
            if (calendarType != null && String.valueOf(0).equals(calendarType)) {
                MoxtraCalendarService moxtra = (MoxtraCalendarService)uiCalendarView.getApplicationComponent(MoxtraCalendarService.class);
                moxtra.deleteMeet();
            }
        }
    }
}

