/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar.webui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.calendar.MoxtraCalendarApplication;
import org.exoplatform.moxtra.calendar.MoxtraCalendarException;
import org.exoplatform.moxtra.calendar.webui.MoxtraUserSelector;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:templates/calendar/webui/UIPopup/UIMoxtraUserSelector.gtmpl", events={@EventConfig(listeners={AddMoxtraUsersActionListener.class}), @EventConfig(listeners={CloseMoxtraUsersActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE)})
@Serialized
public class UIMoxtraUserSelector
extends UIForm
implements MoxtraUserSelector,
UIPopupComponent {
    private static final Log LOG = ExoLogger.getExoLogger(UIMoxtraUserSelector.class);
    private List<MoxtraUser> selectedUsers = new ArrayList<MoxtraUser>();
    private UIPageIterator usersIterator;
    private MoxtraMeet meet;
    private List<MoxtraUser> selectorUsers;

    public UIMoxtraUserSelector() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput("Quick Search", "Quick Search", null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("filter", "filter", this.getFilters()));
        this.usersIterator = new UIPageIterator();
        this.usersIterator.setId("UISelectMoxtraUserPage");
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public List<MoxtraUser> getSelectedUsers() {
        return this.selectedUsers;
    }

    @Override
    public <T extends UIComponent> T getComponent() {
        return (T)this;
    }

    public List<MoxtraUser> getPageUsers() {
        List pageUsers;
        try {
            pageUsers = this.usersIterator.getCurrentPageData();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting current page data in users iterator", (Throwable)e);
            return Collections.emptyList();
        }
        for (MoxtraUser user : pageUsers) {
            UICheckBoxInput uiUserCheckBoxInput = this.getUICheckBoxInput(user.getName());
            if (uiUserCheckBoxInput == null) {
                uiUserCheckBoxInput = new UICheckBoxInput(user.getName(), user.getName(), Boolean.valueOf(false));
                this.addUIFormInput((UIFormInput)uiUserCheckBoxInput);
            }
            uiUserCheckBoxInput.setChecked(this.usersIterator.isSelectedItem(user.getName()));
        }
        return pageUsers;
    }

    public String[] getActions() {
        return new String[]{"AddMoxtraUsers", "CloseMoxtraUsers"};
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public long getAvailablePage() {
        return this.usersIterator.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.usersIterator.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.usersIterator.setCurrentPage(page);
    }

    protected void filter(String keyword, String field) {
        ArrayList<MoxtraUser> res = new ArrayList<MoxtraUser>();
        keyword = keyword.toUpperCase().toLowerCase();
        if (field.equals("name")) {
            for (MoxtraUser user : this.selectorUsers) {
                if (user.getName().toUpperCase().toLowerCase().indexOf(keyword) < 0) continue;
                res.add(user);
            }
        }
        this.setUsers(res);
    }

    @Override
    public void init(MoxtraCalendarApplication moxtra) throws MoxtraCalendarException, MoxtraException, MoxtraConfigurationException {
        this.meet = moxtra.getMeet();
        this.selectorUsers = moxtra.getUserContacts();
        this.setUsers(this.selectorUsers);
        this.selectedUsers.clear();
    }

    protected void setUsers(List<MoxtraUser> users) {
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(MoxtraUser.class, users), 15);
        this.usersIterator.setPageList((PageList)pageList);
    }

    protected List<SelectItemOption<String>> getFilters() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("name", (Object)"name"));
        options.add(new SelectItemOption("email", (Object)"email"));
        return options;
    }

    protected void addUsers() {
        for (MoxtraUser user : this.selectorUsers) {
            UICheckBoxInput input = this.getUICheckBoxInput(user.getName());
            if (input == null) continue;
            boolean checked = input.isChecked();
            this.usersIterator.setSelectedItem(user.getName(), checked);
            if (!checked) continue;
            this.meet.addUser(user);
            this.selectedUsers.add(user);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIMoxtraUserSelector> {
        public void execute(Event<UIMoxtraUserSelector> event) throws Exception {
            UIMoxtraUserSelector uiForm = (UIMoxtraUserSelector)event.getSource();
            String keyword = (String)uiForm.getUIStringInput("Quick Search").getValue();
            String field = (String)uiForm.getUIFormSelectBox("filter").getValue();
            uiForm.filter(keyword, field);
            if (field == null || field.trim().length() == 0) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class ShowPageActionListener
    extends EventListener<MoxtraUserSelector> {
        public void execute(Event<MoxtraUserSelector> event) throws Exception {
            MoxtraUserSelector selector = (MoxtraUserSelector)event.getSource();
            UIMoxtraUserSelector selectorForm = (UIMoxtraUserSelector)selector.getComponent();
            selectorForm.addUsers();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            selectorForm.updateCurrentPage(page);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)selectorForm);
        }
    }

    public static class CloseMoxtraUsersActionListener
    extends EventListener<MoxtraUserSelector> {
        public void execute(Event<MoxtraUserSelector> event) throws Exception {
            MoxtraUserSelector selector = (MoxtraUserSelector)event.getSource();
            UIMoxtraUserSelector selectorForm = (UIMoxtraUserSelector)selector.getComponent();
            selectorForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class AddMoxtraUsersActionListener
    extends EventListener<MoxtraUserSelector> {
        public void execute(Event<MoxtraUserSelector> event) throws Exception {
            MoxtraUserSelector selector = (MoxtraUserSelector)event.getSource();
            UIMoxtraUserSelector selectorForm = (UIMoxtraUserSelector)selector.getComponent();
            selectorForm.addUsers();
            Set selectedNames = selectorForm.usersIterator.getSelectedItems();
            if (selectedNames.size() == 0) {
                UIApplication uiApp = (UIApplication)selectorForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIUserSelector.msg.user-required", null));
                return;
            }
            selectorForm.getParent().getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

