/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.webui;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.moxtra.webui.MoxtraApplicationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class MoxtraLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final Log LOG = ExoLogger.getLogger(MoxtraLifecycle.class);

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        this.activate(app, context);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
        try {
            this.deactivate(app, context);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deactivating Moxtra apps on request failure", (Throwable)e);
        }
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        this.deactivate(app, context);
    }

    public void onDestroy(Application app) throws Exception {
    }

    protected void activate(Application app, WebuiRequestContext context) throws Exception {
        ExoContainer container = app.getApplicationServiceContainer();
        if (container != null) {
            MoxtraApplicationService moxtraApps = (MoxtraApplicationService)container.getComponentInstanceOfType(MoxtraApplicationService.class);
            UIApplication uiApp = context.getUIApplication();
            if (uiApp == null) {
                WebuiApplication webuiApp = (WebuiApplication)app;
                uiApp = webuiApp.getStateManager().restoreUIRootComponent(context);
            }
            if (uiApp != null) {
                moxtraApps.activate(uiApp);
            }
        }
    }

    protected void deactivate(Application app, WebuiRequestContext context) throws Exception {
        ExoContainer container = app.getApplicationServiceContainer();
        if (container != null) {
            MoxtraApplicationService moxtraApps = (MoxtraApplicationService)container.getComponentInstanceOfType(MoxtraApplicationService.class);
            UIApplication uiApp = context.getUIApplication();
            if (uiApp != null) {
                moxtraApps.deactivate(uiApp);
            }
        }
    }
}

