/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar;

import java.util.Calendar;
import java.util.Map;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.calendar.MoxtraCalendarService;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.impl.JobSchedulerServiceImpl;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class MoxtraMeetDownloadJob
implements Job,
InterruptableJob {
    public static final String DATA_USER_ID = "user_id";
    public static final String DATA_CALENDAR_ID = "calendar_id";
    public static final String DATA_EVENT_ID = "event_id";
    public static final String DATA_MOXTRA_USER_ID = "moxtra_user_id";
    public static final String DATA_MOXTRA_USER_EMAIL = "moxtra_user_email";
    public static final String DATA_MOXTRA_BINDER_ID = "moxtra_binder_id";
    public static final String DATA_MOXTRA_MEET_SESSION_KEY = "moxtra_meet_session_key";
    public static final String DATA_MEET_NODE_WORKSPACE = "meet_node_workspace";
    public static final String DATA_MEET_NODE_PATH = "meet_node_path";
    protected static final Log LOG = ExoLogger.getLogger(MoxtraMeetDownloadJob.class);

    public void interrupt() throws UnableToInterruptJobException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail job = context.getJobDetail();
        JobDataMap data = job.getJobDataMap();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CalendarService calendar = (CalendarService)container.getComponentInstance(CalendarService.class);
        MoxtraCalendarService moxtra = (MoxtraCalendarService)container.getComponentInstance(MoxtraCalendarService.class);
        try {
            moxtra.prepareJobEnvironment(job);
            try {
                String exoUserId = data.getString(DATA_USER_ID);
                CalendarEvent event = calendar.getEvent(exoUserId, data.getString(DATA_EVENT_ID));
                String status = moxtra.downloadMeetVideo(exoUserId, event);
                if (status != null && (status.equals(MoxtraMeet.SESSION_SCHEDULED) || status.equals(MoxtraMeet.SESSION_STARTED))) {
                    JobSchedulerServiceImpl schedulerService = (JobSchedulerServiceImpl)container.getComponentInstance(JobSchedulerServiceImpl.class);
                    String jobName = job.getKey().getName();
                    String jobGroup = job.getKey().getGroup();
                    JobDetailImpl newJob = new JobDetailImpl();
                    newJob.setName(jobName);
                    newJob.setGroup(jobGroup);
                    newJob.setJobClass(job.getJobClass());
                    newJob.setDescription(newJob.getDescription());
                    newJob.getJobDataMap().putAll((Map)job.getJobDataMap());
                    SimpleTriggerImpl trigger = new SimpleTriggerImpl();
                    trigger.setName(jobName);
                    trigger.setGroup(jobGroup);
                    Calendar downloadTime = Calendar.getInstance();
                    downloadTime.add(12, 5);
                    trigger.setStartTime(downloadTime.getTime());
                    schedulerService.addJob(job, (Trigger)trigger);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Meet recordings download for event " + event.getSummary() + " not ready and rescheduled to " + downloadTime.getTime()));
                    }
                } else if (MoxtraMeet.SESSION_DELETED.equals(status)) {
                    LOG.warn((Object)("Meet for event " + event.getSummary() + " was deleted and video recordings cannot be download"));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Meet recordings download for event " + event.getSummary() + " canceled. See above log messages for a cause."));
                }
            }
            finally {
                moxtra.cleanupJobEnvironment(job);
            }
        }
        catch (MoxtraException e) {
            throw new JobExecutionException("Error processing Moxtra meet video download", (Throwable)e);
        }
        catch (Exception e) {
            throw new JobExecutionException("Error processing Moxtra meet video download", (Throwable)e);
        }
    }
}

