/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar.webui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.calendar.MoxtraCalendarApplication;
import org.exoplatform.moxtra.calendar.MoxtraCalendarException;
import org.exoplatform.moxtra.calendar.webui.MoxtraUserSelector;
import org.exoplatform.moxtra.calendar.webui.UIMoxtraUserSelector;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.webui.MoxtraAction;
import org.exoplatform.moxtra.webui.component.UIActionCheckBoxInput;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfigs(value={@ComponentConfig(template="classpath:templates/calendar/webui/UIPopup/UIEmeetingTab.gtmpl", events={@EventConfig(listeners={StartMeetActionListener.class}, phase=Event.Phase.PROCESS)})})
public class UIEmeetingTab
extends UIFormInputWithActions {
    public static final String FIELD_ENABLE_MEET = "enableMeet".intern();
    public static final String FIELD_STARTED_MEET = "startedMeet".intern();
    public static final String FIELD_ENDED_MEET = "endedMeet".intern();
    public static final String FIELD_PLANED_MEET = "planedMeet".intern();
    public static final String FIELD_CANCELED_MEET = "canceledMeet".intern();
    public static final String FIELD_INVITE_MOXTRA_USER = "inviteMoxtraUser".intern();
    public static final String FIELD_MEET_LINK = "meetLink".intern();
    public static final String FIELD_MEET_LINK_HINT = "meetLinkHint".intern();
    public static final String FIELD_MEET_AGENDA = "meetAgenda".intern();
    public static final String FIELD_MEET_SCHEDULE = "meetSchedule".intern();
    public static final String FIELD_MEET_SCHEDULE_START = "meetScheduleStart".intern();
    public static final String FIELD_MEET_SCHEDULE_END = "meetScheduleEnd".intern();
    public static final String FIELD_ENABLE_MEET_AUTORECORDING = "meetAutorecording".intern();
    public static final String MESSAGE_MEET_CREATION_INFO = "meetCreationInfo".intern();
    public static final String MESSAGE_POWERED_BY = "poweredBy".intern();
    public static final String MESSAGE_START_MEET_HINT = "startMeetHint".intern();
    public static final String MESSAGE_JOIN_MEET_HINT = "joinMeetHint".intern();
    public static final String MESSAGE_STARTED_MEET_HINT = "startedMeetHint".intern();
    public static final String LIST_MEET_PARTICIPANTS = "UIMoxtraMeetParticipantsList".intern();
    public static final String ACTION_AUTH = "loginMoxtra".intern();
    public static final String ACTION_AUTH_HINT = "loginMoxtraHint".intern();
    public static final String ACTION_START_MEET = "StartMeet".intern();
    public static final String ACTION_JOIN_MEET = "JoinMeet".intern();
    public static final String ACTION_SELECT_MOXTRA_USERS = "SelectMoxtraUsers".intern();
    public static final String ACTION_INVITE_EMAIL_USERS = "InviteEmailUsers".intern();
    public static final String CONTAINER_MOXTRA_USER_SELECTOR = "UIMoxtraUserSelectorPopupContainer";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    protected static final String TAB_EVENTDETAIL = "eventDetail".intern();
    protected static final String FIELD_CALENDAR = "calendar".intern();
    protected static final String COLON = ":".intern();
    protected static final String COMMA = ",".intern();
    private static final Log LOG = ExoLogger.getExoLogger(UIEmeetingTab.class);
    protected final Map<String, List<UIFormInputWithActions.ActionData>> moxtraActions = new HashMap<String, List<UIFormInputWithActions.ActionData>>();
    protected MoxtraCalendarApplication moxtra;
    protected MoxtraUser user;
    protected MoxtraMeet meet;
    protected boolean isHostUser;

    public MoxtraCalendarApplication getMoxtra() {
        return this.moxtra;
    }

    public String getMeetLabel() throws Exception {
        UIForm eventForm = this.getParentForm();
        String label = this.isMeetSaved() ? (this.meet.isStarted() ? eventForm.getLabel(FIELD_STARTED_MEET) : (this.meet.isEnded() ? eventForm.getLabel(FIELD_ENDED_MEET) : (this.meet.isScheduled() ? (this.isHostUser() ? eventForm.getLabel(FIELD_ENABLE_MEET) : eventForm.getLabel(FIELD_PLANED_MEET)) : eventForm.getLabel(FIELD_CANCELED_MEET)))) : eventForm.getLabel(FIELD_ENABLE_MEET);
        return label;
    }

    public String getAuthLink() throws MoxtraCalendarException, OAuthSystemException, MoxtraConfigurationException {
        return this.moxtra.getAuthorizationLink();
    }

    public boolean isAuthorized() throws MoxtraCalendarException {
        return this.moxtra.isAuthorized();
    }

    public boolean isMeetEnabled() throws MoxtraCalendarException {
        return this.meet != null ? !this.meet.hasDeleted() : false;
    }

    public boolean isMeetNew() throws MoxtraCalendarException {
        return this.isMeetEnabled() && this.meet.isNew();
    }

    public boolean isMeetSaved() throws MoxtraCalendarException {
        return this.isMeetEnabled() && !this.meet.isNew();
    }

    public boolean isMeetStarted() throws MoxtraCalendarException {
        return this.isMeetEnabled() && this.meet.isStarted();
    }

    public boolean isCanStartMeet() throws MoxtraCalendarException {
        if (this.isMeetEnabled()) {
            if (!(!this.isHostUser() || this.meet.isNew() || this.meet.isEnded() || this.meet.isDeleted() || this.meet.isExpired())) {
                return true;
            }
            return this.meet.canStart();
        }
        return false;
    }

    public boolean isHostUser() {
        return this.isHostUser;
    }

    public String getStartMeetLink() throws MoxtraCalendarException {
        if (this.isMeetEnabled()) {
            return this.meet.getStartMeetUrl();
        }
        return "javascript:void(0);";
    }

    @Deprecated
    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return this.moxtraActions.get(fieldName);
    }

    public void initMoxtra(MoxtraCalendarApplication moxtra) throws Exception {
        boolean autoRecord;
        boolean meetStarted;
        boolean meetEnded;
        boolean meetEnabled;
        this.moxtra = moxtra;
        if (moxtra.hasMeet()) {
            this.user = moxtra.getUser();
            this.meet = moxtra.getMeet();
        } else {
            this.user = null;
            this.meet = null;
        }
        if (this.isMeetEnabled()) {
            meetEnabled = true;
            meetEnded = this.meet.isEnded() || this.meet.isDeleted() || this.meet.isExpired();
            meetStarted = this.meet.isStarted();
            if (this.meet.isNew()) {
                this.isHostUser = true;
            } else if (meetStarted) {
                this.isHostUser = false;
            } else {
                try {
                    this.isHostUser = this.user.equals((Object)this.meet.getHostUser());
                }
                catch (MoxtraException e) {
                    this.isHostUser = false;
                }
            }
            autoRecord = this.meet.isAutoRecording();
            if (!this.meet.isNew()) {
                UIFormStringInput meetLink = new UIFormStringInput(FIELD_MEET_LINK, FIELD_MEET_LINK, this.meet.getStartMeetUrl());
                meetLink.setDisabled(true);
                this.addUIFormInput((UIFormInput)meetLink);
                UIFormTextAreaInput meetAgenda = new UIFormTextAreaInput(FIELD_MEET_AGENDA, FIELD_MEET_AGENDA, this.meet.getAgenda());
                meetAgenda.setDisabled(true);
                this.addUIFormInput((UIFormInput)meetAgenda);
                DateFormat dateFormat = this.userDateFormat();
                UIFormStringInput meetScheduleStart = new UIFormStringInput(FIELD_MEET_SCHEDULE_START, FIELD_MEET_SCHEDULE_START, dateFormat.format(this.meet.getStartTime()));
                meetScheduleStart.setDisabled(true);
                this.addUIFormInput((UIFormInput)meetScheduleStart);
                UIFormStringInput meetScheduleEnd = new UIFormStringInput(FIELD_MEET_SCHEDULE_END, FIELD_MEET_SCHEDULE_END, dateFormat.format(this.meet.getEndTime()));
                meetScheduleEnd.setDisabled(true);
                this.addUIFormInput((UIFormInput)meetScheduleEnd);
            }
        } else {
            meetStarted = false;
            meetEnded = false;
            meetEnabled = false;
            this.isHostUser = true;
            autoRecord = false;
        }
        if (this.isHostUser) {
            // empty if block
        }
        UIActionCheckBoxInput enableCheckbox = (UIActionCheckBoxInput)this.getParentForm().createUIComponent(UIActionCheckBoxInput.class, null, FIELD_ENABLE_MEET);
        enableCheckbox.initMoxtra((MoxtraAction)new MeetEnabler(), !this.isHostUser || meetEnded, meetEnabled);
        this.addUIFormInput((UIFormInput)enableCheckbox);
        UIActionCheckBoxInput autorecCheckbox = (UIActionCheckBoxInput)this.getParentForm().createUIComponent(UIActionCheckBoxInput.class, null, FIELD_ENABLE_MEET_AUTORECORDING);
        autorecCheckbox.initMoxtra((MoxtraAction)new AutorecordingEnabled(), !this.isHostUser || meetStarted || meetEnded, autoRecord);
        this.addUIFormInput((UIFormInput)autorecCheckbox);
        if (meetStarted) {
            JavascriptManager jsManager = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
            RequireJS requireJS = jsManager.getRequireJS();
            requireJS.require("SHARED/jquery", "$");
            requireJS.addScripts("$('span>a.meetStartAction').tooltip('show');");
        }
    }

    protected UIForm getParentForm() {
        return (UIForm)this.getParent();
    }

    @Deprecated
    protected void setMeetUsers(List<MoxtraUser> users) {
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(MoxtraUser.class, users), 15);
        ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().setPageList((PageList)pageList);
    }

    protected DateFormat userDateFormat() throws MoxtraCalendarException, Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        CalendarSetting setting = this.moxtra.getCalendarSetting();
        String dateFormatPattern = setting.getDateFormat() + " " + setting.getTimeFormat();
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone(setting.getTimeZone()));
        return dateFormat;
    }

    protected String getCalendarId() {
        String[] values;
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getParentForm().getChildById(TAB_EVENTDETAIL);
        String value = (String)((UIFormSelectBoxWithGroups)eventDetailTab.findComponentById(FIELD_CALENDAR)).getValue();
        if (value != null && value.length() > 0 && (values = value.split(COLON)).length > 0) {
            return value.split(COLON)[1];
        }
        return value;
    }

    protected String getCalendarType() {
        String[] values;
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getParentForm().getChildById(TAB_EVENTDETAIL);
        String value = (String)((UIFormSelectBoxWithGroups)eventDetailTab.findComponentById(FIELD_CALENDAR)).getValue();
        if (value != null && value.length() > 0 && (values = value.split(COLON)).length > 0) {
            return value.split(COLON)[0];
        }
        return null;
    }

    protected class AutorecordingEnabled
    implements MoxtraAction<Event<UIActionCheckBoxInput>, Boolean> {
        protected AutorecordingEnabled() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean execute(Event<UIActionCheckBoxInput> event) {
            UIActionCheckBoxInput checkbox = (UIActionCheckBoxInput)event.getSource();
            try {
                boolean res;
                if (checkbox.isChecked()) {
                    UIEmeetingTab.this.meet.editAutoRecording(Boolean.valueOf(true));
                    res = true;
                } else {
                    UIEmeetingTab.this.meet.editAutoRecording(Boolean.valueOf(false));
                    res = false;
                }
                Boolean bl = res;
                return bl;
            }
            finally {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIEmeetingTab.this);
            }
        }
    }

    protected class MeetEnabler
    implements MoxtraAction<Event<UIActionCheckBoxInput>, Boolean> {
        protected MeetEnabler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean execute(Event<UIActionCheckBoxInput> event) {
            UIActionCheckBoxInput checkbox = (UIActionCheckBoxInput)event.getSource();
            JavascriptManager jsManager = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
            RequireJS requireJS = jsManager.getRequireJS();
            try {
                boolean res;
                if (checkbox.isChecked()) {
                    if (UIEmeetingTab.this.moxtra.isAuthorized()) {
                        UIEmeetingTab.this.user = UIEmeetingTab.this.moxtra.getUser();
                        UIEmeetingTab.this.meet = UIEmeetingTab.this.moxtra.enableMeet();
                        res = true;
                    } else {
                        requireJS.require("SHARED/jquery", "$");
                        requireJS.addScripts("$('a.moxtraAuthLink').tooltip('show');");
                        res = false;
                    }
                } else {
                    UIEmeetingTab.this.meet = UIEmeetingTab.this.moxtra.disableMeet();
                    res = false;
                }
                Boolean bl = res;
                return bl;
            }
            catch (MoxtraCalendarException e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEmeetingTab.message.ErrorEnablingMeet", null));
                Boolean bl = false;
                return bl;
            }
            catch (MoxtraException e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEmeetingTab.message.ErrorReadingUser", null));
                Boolean bl = false;
                return bl;
            }
            finally {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIEmeetingTab.this);
            }
        }
    }

    public static class StartMeetActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab moxtraTab = (UIEmeetingTab)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)moxtraTab);
        }
    }

    @Deprecated
    public static class DeleteActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab moxtraTab = (UIEmeetingTab)((Object)event.getSource());
            MoxtraMeet meet = moxtraTab.meet;
            String userName = event.getRequestContext().getRequestParameter("objectId");
            for (MoxtraUser user : meet.getUsers()) {
                if (!user.getName().equals(userName)) continue;
                if (meet.getHostUser().equals((Object)user)) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEmeetingTab.message.CannotRemoveMeetCreator", null));
                    break;
                }
                meet.removeUser(user);
                break;
            }
            moxtraTab.setMeetUsers(meet.getUsers());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)moxtraTab);
        }
    }

    @Deprecated
    public static class AddMeetUsersActionListener
    extends EventListener<MoxtraUserSelector> {
        public void execute(Event<MoxtraUserSelector> event) throws Exception {
            MoxtraUserSelector usersSelector = (MoxtraUserSelector)event.getSource();
            UIContainer formContainer = (UIContainer)usersSelector.getComponent().getParent().getParent().getParent();
            UIEmeetingTab moxtraTab = (UIEmeetingTab)formContainer.findFirstComponentOfType(UIEmeetingTab.class);
            MoxtraMeet meet = moxtraTab.meet;
            moxtraTab.setMeetUsers(meet.getUsers());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)moxtraTab);
            UIPopupContainer popupContainer = (UIPopupContainer)formContainer.getChild(UIPopupContainer.class);
            if (popupContainer != null) {
                popupContainer.cancelPopupAction();
            }
        }
    }

    @Deprecated
    public static class SelectMoxtraUsersActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab moxtraTab = (UIEmeetingTab)((Object)event.getSource());
            UIContainer formContainer = (UIContainer)moxtraTab.getParentForm().getParent();
            UIPopupContainer popupContainer = (UIPopupContainer)formContainer.getChild(UIPopupContainer.class);
            if (popupContainer == null) {
                popupContainer = (UIPopupContainer)formContainer.addChild(UIPopupContainer.class, UIEmeetingTab.CONTAINER_MOXTRA_USER_SELECTOR, UIEmeetingTab.CONTAINER_MOXTRA_USER_SELECTOR);
            } else {
                popupContainer.deActivate();
            }
            UIMoxtraUserSelector uiUserSelector = (UIMoxtraUserSelector)popupContainer.activate(UIMoxtraUserSelector.class, null, 740, 400);
            uiUserSelector.init(moxtraTab.moxtra);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)formContainer);
        }
    }

    @Deprecated
    public static class DisableMeetActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab uiMoxtraTab = (UIEmeetingTab)((Object)event.getSource());
            uiMoxtraTab.moxtra.disableMeet();
            UICheckBoxInput enableCheckbox = (UICheckBoxInput)uiMoxtraTab.getChildById(FIELD_ENABLE_MEET);
            enableCheckbox.setValue(Boolean.valueOf(false));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMoxtraTab);
        }
    }

    @Deprecated
    public static class EnableMeetActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab uiMoxtraTab = (UIEmeetingTab)((Object)event.getSource());
            uiMoxtraTab.moxtra.enableMeet();
            UICheckBoxInput enableCheckbox = (UICheckBoxInput)uiMoxtraTab.getChildById(FIELD_ENABLE_MEET);
            enableCheckbox.setValue(Boolean.valueOf(true));
            JavascriptManager jsManager = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
            RequireJS requireJS = jsManager.getRequireJS();
            requireJS.require("SHARED/jquery", "$");
            requireJS.addScripts("$('#" + ACTION_SELECT_MOXTRA_USERS + "').tooltip('show');");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMoxtraTab);
        }
    }

    @Deprecated
    public static class DisableAutorecordingtActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab uiMoxtraTab = (UIEmeetingTab)((Object)event.getSource());
            if (uiMoxtraTab.isMeetEnabled()) {
                MoxtraMeet meet = uiMoxtraTab.meet;
                meet.editAutoRecording(Boolean.valueOf(false));
            }
            UICheckBoxInput enableCheckbox = (UICheckBoxInput)uiMoxtraTab.getChildById(FIELD_ENABLE_MEET_AUTORECORDING);
            enableCheckbox.setValue(Boolean.valueOf(false));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)enableCheckbox);
        }
    }

    @Deprecated
    public static class EnableAutorecordingActionListener
    extends EventListener<UIEmeetingTab> {
        public void execute(Event<UIEmeetingTab> event) throws Exception {
            UIEmeetingTab uiMoxtraTab = (UIEmeetingTab)((Object)event.getSource());
            if (uiMoxtraTab.isMeetEnabled()) {
                MoxtraMeet meet = uiMoxtraTab.meet;
                meet.editAutoRecording(Boolean.valueOf(true));
            }
            UICheckBoxInput enableCheckbox = (UICheckBoxInput)uiMoxtraTab.getChildById(FIELD_ENABLE_MEET_AUTORECORDING);
            enableCheckbox.setValue(Boolean.valueOf(true));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)enableCheckbox);
        }
    }

    @Deprecated
    public static class CloseActionListener
    extends EventListener<MoxtraUserSelector> {
        public void execute(Event<MoxtraUserSelector> event) throws Exception {
            MoxtraUserSelector usersSelector = (MoxtraUserSelector)event.getSource();
            UIContainer formContainer = (UIContainer)usersSelector.getComponent().getParent().getParent().getParent();
            UIPopupContainer popupContainer = (UIPopupContainer)formContainer.getChild(UIPopupContainer.class);
            if (popupContainer != null) {
                popupContainer.cancelPopupAction();
            }
        }
    }
}

