/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar.webui;

import org.exoplatform.moxtra.calendar.MoxtraCalendarException;
import org.exoplatform.moxtra.calendar.webui.UIEmeetingTab;
import org.exoplatform.moxtra.calendar.webui.UIInvitationForm;
import org.exoplatform.moxtra.webui.MoxtraNotActivatedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfigs(value={@ComponentConfig(events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIEventForm
extends UIForm {
    private static final Log LOG = ExoLogger.getExoLogger(UIEventForm.class);

    public static class CancelActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiForm = (UIForm)event.getSource();
            UIContainer formContainer = (UIContainer)uiForm.getParent();
            UIEmeetingTab moxtraTab = (UIEmeetingTab)formContainer.findComponentById(UIEmeetingTab.class.getSimpleName());
            moxtraTab.moxtra.reset();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiForm = (UIForm)event.getSource();
            UIContainer formContainer = (UIContainer)uiForm.getParent();
            UIEmeetingTab moxtraTab = (UIEmeetingTab)formContainer.findComponentById(UIEmeetingTab.class.getSimpleName());
            String calType = moxtraTab.getCalendarType();
            try {
                if (moxtraTab.moxtra.hasMeet() && String.valueOf(0).equals(calType)) {
                    moxtraTab.moxtra.saveMeet();
                }
            }
            catch (MoxtraNotActivatedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error saving private meet: " + e.getMessage()));
                }
            }
            catch (MoxtraCalendarException e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEmeetingTab.error.ErrorSavingMeet", new Object[]{e.getMessage()}));
            }
        }
    }

    public static class AddParticipantActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm uiForm = (UIForm)event.getSource();
            UIContainer formContainer = (UIContainer)uiForm.getParent();
            UIContainer uiPopupAction = (UIContainer)formContainer.getChildById("UICalendarChildPopup");
            UIPopupWindow popupWindow = (UIPopupWindow)uiPopupAction.getChildById("UICalendarChildPopupWindow");
            UIContainer uiInvitationContainer = (UIContainer)popupWindow.getUIComponent();
            UIForm uiInvitationForm = (UIForm)uiInvitationContainer.getChildById("UIInvitationForm");
            UIEmeetingTab moxtraTab = (UIEmeetingTab)formContainer.findComponentById(UIEmeetingTab.class.getSimpleName());
            moxtraTab.moxtra.mergeConfigs(uiInvitationForm.getComponentConfig(), UIInvitationForm.class);
        }
    }
}

