/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.meetbutton;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.MoxtraService;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.moxtra.webui.MoxtraApplication;
import org.exoplatform.moxtra.webui.MoxtraNotActivatedException;
import org.exoplatform.moxtra.webui.MoxtraNotInitializedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;

public class MoxtraMeetButtonApplication
implements MoxtraApplication {
    public static final Log LOG = ExoLogger.getLogger(MoxtraMeetButtonApplication.class);
    protected final ThreadLocal<UIApplication> uiApp = new ThreadLocal();
    protected final ThreadLocal<UIContainer> requestComponent = new ThreadLocal();
    protected final Set<Component> mergedConfigs = new HashSet<Component>();
    protected MoxtraService moxtra;

    public void init() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.moxtra = (MoxtraService)container.getComponentInstanceOfType(MoxtraService.class);
    }

    public boolean isAuthorized() {
        return this.moxtra().getClient().isAuthorized();
    }

    public String getAuthorizationLink() throws OAuthSystemException {
        return this.moxtra().getClient().authorizer().authorizationLink();
    }

    public void activate(UIApplication uiApp) {
        this.uiApp.set(uiApp);
        String appId = uiApp.getId();
        if (appId.equals("UISpaceActivityStreamPortlet") || appId.equals("UIUserActivityStreamPortlet") || appId.equals("UIMembersPortlet") || appId.equals("UIAllPeoplePortlet") || appId.equals("UIProfilePortlet") || appId.equals("UIConnectionsPortlet")) {
            try {
                WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                JavascriptManager jsManager = requestContext.getJavascriptManager();
                RequireJS requireJS = jsManager.getRequireJS();
                Object obj = requestContext.getAttribute(USER_INIT_SCRIPT);
                if (obj == null) {
                    String userName = requestContext.getRemoteUser();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Activating app for Meet Button: " + uiApp + ", user " + userName));
                    }
                    String authLink = this.getAuthorizationLink();
                    requireJS.require("SHARED/exoMoxtra", "moxtra");
                    requireJS.addScripts("moxtra.initUser('" + userName + "', " + this.isAuthorized() + ", '" + authLink + "');");
                    requestContext.setAttribute(USER_INIT_SCRIPT, (Object)userName);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<< Application already activated for Meet Button: " + uiApp + ", user " + obj));
                }
                requireJS.addScripts("moxtra.initMeetButton('" + appId + "');");
            }
            catch (OAuthSystemException e) {
                LOG.error((Object)("Error activating app for Meet Button: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void reset() {
        this.requestComponent.remove();
    }

    public void deactivate(UIApplication uiApp) {
        this.uiApp.remove();
        this.reset();
    }

    public boolean isInitialized() {
        return this.moxtra != null;
    }

    protected void initContext(UIContainer comp) throws MoxtraException, MoxtraConfigurationException {
        this.requestComponent.set(comp);
    }

    protected <T extends UIComponent> T findComponent(UIContainer container, String typeName) {
        Object child = container.findComponentById(typeName);
        if (child == null) {
            for (UIComponent cc : container.getChildren()) {
                if (cc.getClass().getSimpleName().equals(typeName)) {
                    child = cc;
                    break;
                }
                if (!(cc instanceof UIContainer) || (child = this.findComponent((UIContainer)cc, typeName)) == null) continue;
                break;
            }
        }
        return (T)child;
    }

    protected <T extends UIComponent> T findChildBySuperType(UIContainer container, String superTypeName) {
        List<T> childs = this.findChildsBySuperType(container, superTypeName, false);
        UIComponent child = null;
        for (UIComponent cc : childs) {
            if (child != null) {
                if (!cc.isRendered()) continue;
                child = cc;
                break;
            }
            child = cc;
            if (!cc.isRendered()) continue;
            break;
        }
        return (T)child;
    }

    protected <T extends UIComponent> T findRenderedChildBySuperType(UIContainer container, String superTypeName) {
        List<T> childs = this.findChildsBySuperType(container, superTypeName, false);
        for (UIComponent cc : childs) {
            if (!cc.isRendered()) continue;
            return (T)cc;
        }
        return null;
    }

    protected <T extends UIComponent> List<T> findChildsBySuperType(UIContainer container, String superTypeName, boolean deep) {
        ArrayList<Object> childs = new ArrayList<Object>();
        for (UIComponent cc : container.getChildren()) {
            Class<?> superType = cc.getClass().getSuperclass();
            if (superType == null || !superType.getSimpleName().equals(superTypeName)) continue;
            childs.add(cc);
            if (!deep || !(cc instanceof UIContainer)) continue;
            List<T> ccChilds = this.findChildsBySuperType((UIContainer)cc, superTypeName, deep);
            childs.addAll(ccChilds);
        }
        return childs;
    }

    protected <T extends UIComponent> T findRenderedChildByInterface(UIContainer container, String interfaceName) {
        List<T> childs = this.findChildsByInterface(container, interfaceName, false);
        for (UIComponent cc : childs) {
            if (!cc.isRendered()) continue;
            return (T)cc;
        }
        return null;
    }

    protected <T extends UIComponent> List<T> findChildsByInterface(UIContainer container, String interfaceName, boolean deep) {
        ArrayList<Object> childs = new ArrayList<Object>();
        for (UIComponent cc : container.getChildren()) {
            for (Class<?> interfaceType : cc.getClass().getInterfaces()) {
                if (!interfaceType.getSimpleName().equals(interfaceName)) continue;
                childs.add(cc);
                if (!deep || !(cc instanceof UIContainer)) continue;
                List<T> ccChilds = this.findChildsByInterface((UIContainer)cc, interfaceName, deep);
                childs.addAll(ccChilds);
            }
        }
        return childs;
    }

    protected MoxtraService moxtra() throws MoxtraNotInitializedException {
        MoxtraService moxtra = this.moxtra;
        if (moxtra != null) {
            return moxtra;
        }
        throw new MoxtraNotInitializedException("Moxtra application not initialized");
    }

    protected UIContainer comp() throws MoxtraNotActivatedException {
        UIContainer comp = this.requestComponent.get();
        if (comp != null) {
            return comp;
        }
        throw new MoxtraNotActivatedException("Moxtra application not activated");
    }

    public void mergeConfigs(Component original, Class<? extends UIComponent> clazz) throws Exception {
        if (!this.mergedConfigs.contains(original)) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            WebuiApplication webuiApp = (WebuiApplication)context.getApplication();
            Component extension = webuiApp.getConfigurationManager().getComponentConfig(clazz, null);
            LinkedHashSet extEvents = new LinkedHashSet(extension.getEvents());
            List events = original.getEvents();
            for (Event oe : events) {
                String eventName = oe.getName();
                Iterator eeiter = extEvents.iterator();
                while (eeiter.hasNext()) {
                    Event ee = (Event)eeiter.next();
                    if (!eventName.equals(ee.getName())) continue;
                    LinkedHashSet names = new LinkedHashSet();
                    names.addAll(oe.getListeners());
                    names.addAll(ee.getListeners());
                    oe.setListeners(new ArrayList(names));
                    original.getUIComponentEventConfig(eventName);
                    extension.getUIComponentEventConfig(eventName);
                    LinkedHashSet listeners = new LinkedHashSet();
                    listeners.addAll(oe.getCachedEventListeners());
                    listeners.addAll(ee.getCachedEventListeners());
                    oe.setCachedEventListeners(new ArrayList(listeners));
                    eeiter.remove();
                }
            }
            if (extEvents.size() > 0) {
                events.addAll(extEvents);
                FieldUtils.writeDeclaredField((Object)original, (String)"eventMap", null, (boolean)true);
            }
            if (extension.getTemplate() != null && extension.getTemplate().length() > 0) {
                FieldUtils.writeDeclaredField((Object)original, (String)"template", (Object)extension.getTemplate(), (boolean)true);
            }
            this.mergedConfigs.add(original);
        }
    }
}

