/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.version.Version;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.ConflictException;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.jcr.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OnlyofficeEditorServiceImpl
implements OnlyofficeEditorService,
Startable {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorServiceImpl.class);
    protected static final Random RANDOM = new Random();
    public static final String CONFIG_HOST = "server-host";
    public static final String CONFIG_SCHEMA = "server-schema";
    public static final String CONFIG_DS_HOST = "documentserver-host";
    public static final String CONFIG_DS_SCHEMA = "documentserver-schema";
    public static final String CONFIG_DS_ACCESS_ONLY = "documentserver-access-only";
    protected static final String TYPE_TEXT = "text";
    protected static final String TYPE_SPREADSHEET = "spreadsheet";
    protected static final String TYPE_PRESENTATION = "presentation";
    protected static final int LOCK_WAIT_ATTEMTS = 20;
    protected static final long LOCK_WAIT_TIMEOUT = 250L;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final IdentityRegistry identityRegistry;
    protected final NodeFinder finder;
    protected final OrganizationService organization;
    protected final ConcurrentHashMap<String, ConcurrentHashMap<String, Config>> active = new ConcurrentHashMap();
    protected final Map<String, String> config;
    protected final String platformUrl;
    protected final String uploadUrl;
    protected final String documentserverHost;
    protected final String documentserverUrl;
    protected final boolean documentserverAccessOnly;
    protected final URI baseWebdavUri;
    protected final Map<String, String> fileTypes = new ConcurrentHashMap<String, String>();
    protected final MessageFormat uploadParams = new MessageFormat("?url={0}&outputtype={1}&filetype={2}&title={3}&key={4}");
    protected final ConcurrentLinkedQueue<OnlyofficeEditorListener> listeners = new ConcurrentLinkedQueue();

    public OnlyofficeEditorServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders, IdentityRegistry identityRegistry, NodeFinder finder, OrganizationService organization, InitParams params) throws ConfigurationException {
        String host;
        String dsHost;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.identityRegistry = identityRegistry;
        this.finder = finder;
        this.organization = organization;
        this.fileTypes.put("docx", TYPE_TEXT);
        this.fileTypes.put("doc", TYPE_TEXT);
        this.fileTypes.put("odt", TYPE_TEXT);
        this.fileTypes.put("txt", TYPE_TEXT);
        this.fileTypes.put("rtf", TYPE_TEXT);
        this.fileTypes.put("mht", TYPE_TEXT);
        this.fileTypes.put("html", TYPE_TEXT);
        this.fileTypes.put("htm", TYPE_TEXT);
        this.fileTypes.put("epub", TYPE_TEXT);
        this.fileTypes.put("pdf", TYPE_TEXT);
        this.fileTypes.put("djvu", TYPE_TEXT);
        this.fileTypes.put("xps", TYPE_TEXT);
        this.fileTypes.put("xlsx", TYPE_SPREADSHEET);
        this.fileTypes.put("xls", TYPE_SPREADSHEET);
        this.fileTypes.put("ods", TYPE_SPREADSHEET);
        this.fileTypes.put("pptx", TYPE_PRESENTATION);
        this.fileTypes.put("ppt", TYPE_PRESENTATION);
        this.fileTypes.put("ppsx", TYPE_PRESENTATION);
        this.fileTypes.put("pps", TYPE_PRESENTATION);
        this.fileTypes.put("odp", TYPE_PRESENTATION);
        PropertiesParam param = params.getPropertiesParam("editor-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters editor-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        String dsSchema = this.config.get(CONFIG_DS_SCHEMA);
        if (dsSchema == null || (dsSchema = dsSchema.trim()).length() == 0) {
            dsSchema = "http";
        }
        if ((dsHost = this.config.get(CONFIG_DS_HOST)) == null || (dsHost = dsHost.trim()).length() == 0) {
            throw new ConfigurationException("Configuration of documentserver-host required");
        }
        this.documentserverHost = dsHost;
        String schema = this.config.get(CONFIG_SCHEMA);
        if (schema == null || (schema = schema.trim()).length() == 0) {
            schema = "http";
        }
        if ((host = this.config.get(CONFIG_HOST)) == null || host.trim().length() == 0) {
            host = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (host == null && interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (host == null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress()) continue;
                        host = address.getHostName();
                    }
                }
            }
            catch (SocketException interfaces) {
                // empty catch block
            }
            if (host == null) {
                try {
                    host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
            }
            LOG.warn((Object)("Configuration of server-host is not set, will use " + host));
        }
        this.documentserverAccessOnly = Boolean.parseBoolean(this.config.get(CONFIG_DS_ACCESS_ONLY));
        StringBuilder documentserverUrl = new StringBuilder();
        documentserverUrl.append(dsSchema);
        documentserverUrl.append("://");
        documentserverUrl.append(this.documentserverHost);
        this.uploadUrl = new StringBuilder(documentserverUrl).append("/FileUploader.ashx").toString();
        this.documentserverUrl = new StringBuilder(documentserverUrl).append("/OfficeWeb/").toString();
        StringBuilder platformUrl = new StringBuilder();
        platformUrl.append(schema);
        platformUrl.append("://");
        platformUrl.append(host);
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentPortalContainerName());
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentRestContextName());
        StringBuilder webdavUrl = new StringBuilder();
        webdavUrl.append((CharSequence)platformUrl);
        webdavUrl.append("/jcr");
        try {
            this.baseWebdavUri = new URI(webdavUrl.toString());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Error parsing WebDAV URL " + webdavUrl, (Throwable)e);
        }
        platformUrl.append("/onlyoffice/editor");
        this.platformUrl = platformUrl.toString();
    }

    @Override
    public void addListener(OnlyofficeEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OnlyofficeEditorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Config getEditor(String userId, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        return this.getEditor(userId, this.nodePath(workspace, path));
    }

    protected Config getEditor(String userId, String nodePath) throws OnlyofficeEditorException, RepositoryException {
        ConcurrentHashMap<String, Config> configs = this.active.get(nodePath);
        if (configs != null) {
            Config config = configs.get(userId);
            if (config == null) {
                try {
                    User user = this.getUser(userId);
                    String lang = this.getUserLang(userId);
                    config = configs.values().iterator().next().forUser(user.getUserName(), user.getFirstName(), user.getLastName(), lang);
                    Config existing = configs.putIfAbsent(userId, config);
                    if (existing != null) {
                        config = existing;
                    }
                    this.fireGet(config);
                }
                catch (NoSuchElementException e) {
                    config = null;
                }
            } else {
                this.fireGet(config);
            }
            return config;
        }
        return null;
    }

    @Override
    public Config createEditor(String userId, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        Node node = this.node(workspace, path);
        String nodePath = this.nodePath(workspace, path);
        if (!node.isNodeType("nt:file")) {
            throw new OnlyofficeEditorException("Only nt:file supported " + nodePath);
        }
        Config config = this.getEditor(userId, nodePath);
        if (config == null) {
            User user = this.getUser(userId);
            String fileType = this.fileType(node);
            String docType = this.documentType(fileType);
            Config.Builder builder = Config.editor(this.documentserverUrl, workspace, path, docType);
            builder.author(userId);
            builder.fileType(fileType);
            builder.created(this.nodeCreated(node));
            builder.folder(node.getParent().getName());
            String lang = this.getUserLang(userId);
            builder.lang(lang);
            builder.mode("edit");
            builder.title(this.nodeTitle(node));
            builder.userId(user.getUserName());
            builder.userFirstName(user.getFirstName());
            builder.userLastName(user.getLastName());
            UUID fileId = this.generateId(workspace, path);
            String key = fileId.toString();
            builder.key(key);
            builder.generateUrls(this.platformUrl);
            config = builder.build();
            ConcurrentHashMap<String, Config> configs = new ConcurrentHashMap<String, Config>();
            configs.put(userId, config);
            ConcurrentHashMap existing = this.active.putIfAbsent(nodePath, configs);
            if (existing != null) {
                configs = existing;
                config = this.getEditor(userId, nodePath);
                if (config == null) {
                    throw new ConflictException("Cannot obtain configuration for already existing editor");
                }
            } else {
                this.active.put(key, configs);
            }
            this.fireCreated(config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContent getContent(String userId, String key) throws OnlyofficeEditorException, RepositoryException {
        ConcurrentHashMap<String, Config> configs = this.active.get(key);
        if (configs != null) {
            Config config = configs.get(userId);
            if (config != null) {
                this.validateUser(userId, config);
                ConversationState contextState = ConversationState.getCurrent();
                SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
                try {
                    Identity userIdentity = this.identityRegistry.getIdentity(userId);
                    if (userIdentity == null) {
                        LOG.warn((Object)("User identity not found " + userId + " for content of " + config.getDocument().getKey() + " " + config.getPath()));
                        throw new OnlyofficeEditorException("User identity not found " + userId);
                    }
                    ConversationState state = new ConversationState(userIdentity);
                    state.setAttribute("subject", (Object)userIdentity.getSubject());
                    ConversationState.setCurrent((ConversationState)state);
                    SessionProvider userProvider = new SessionProvider(state);
                    this.sessionProviders.setSessionProvider(null, userProvider);
                    Node node = this.node(config.getWorkspace(), config.getPath());
                    Node content = this.nodeContent(node);
                    final String mimeType = content.getProperty("jcr:mimeType").getString();
                    AutoCloseInputStream data = new AutoCloseInputStream(content.getProperty("jcr:data").getStream());
                    DocumentContent documentContent = new DocumentContent((InputStream)data){
                        final /* synthetic */ InputStream val$data;
                        {
                            this.val$data = inputStream;
                        }

                        @Override
                        public String getType() {
                            return mimeType;
                        }

                        @Override
                        public InputStream getData() {
                            return this.val$data;
                        }
                    };
                    return documentContent;
                }
                finally {
                    ConversationState.setCurrent((ConversationState)contextState);
                    this.sessionProviders.setSessionProvider(null, contextProvider);
                }
            }
            throw new BadParameterException("User editor not found or already closed " + userId);
        }
        throw new BadParameterException("File key not found " + key);
    }

    @Override
    public boolean canDownloadBy(String hostName) {
        if (this.documentserverAccessOnly) {
            return this.documentserverHost.equals(hostName);
        }
        return true;
    }

    @Override
    public ChangeState getState(String userId, String key) throws OnlyofficeEditorException {
        ConcurrentHashMap<String, Config> configs = this.active.get(key);
        if (configs != null) {
            Config config = configs.get(userId);
            if (config == null) {
                throw new BadParameterException("User editor not found " + userId);
            }
            this.validateUser(userId, config);
            String[] users = this.getCurrentUsers(configs);
            return new ChangeState(false, config.getError(), users);
        }
        return new ChangeState(true, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDocument(String userId, DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        String key = status.getKey();
        ConcurrentHashMap<String, Config> configs = this.active.get(key);
        if (configs == null) throw new BadParameterException("File key not found " + key);
        Config config = configs.get(userId);
        if (config == null) throw new BadParameterException("User editor not found " + userId);
        this.validateUser(userId, config);
        String nodePath = this.nodePath(config.getWorkspace(), config.getPath());
        long statusCode = status.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> Onlyoffice status " + statusCode + " for " + key + ". URL: " + status.getUrl() + ". Users: " + Arrays.toString(status.getUsers()) + " << Local file: " + nodePath));
        }
        if (statusCode == 0L) {
            this.active.remove(key);
            this.active.remove(nodePath);
            LOG.warn((Object)("Received Onlyoffice status: no document with the key identifier could be found. Key: " + key + ". Document " + nodePath));
            throw new OnlyofficeEditorException("Error editing document: document ID not found");
        }
        if (statusCode == 1L) {
            String[] users = status.getUsers();
            this.syncUsers(configs, users);
            return;
        } else if (statusCode == 2L) {
            this.download(config, status);
            this.active.remove(key);
            this.active.remove(nodePath);
            return;
        } else if (statusCode == 3L) {
            this.syncUsers(configs, status.getUsers());
            if (configs.size() <= 1) {
                String url = status.getUrl();
                if (url != null && url.length() > 0) {
                    this.download(config, status);
                    this.active.remove(key);
                    this.active.remove(nodePath);
                    config.setError("Error in editor. Last change was successfully saved");
                    this.fireError(config);
                    LOG.warn((Object)("Received Onlyoffice error of saving document. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Last change was successfully saved for " + nodePath));
                    return;
                } else {
                    LOG.warn((Object)("Received Onlyoffice error of saving document without changes URL. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document " + nodePath));
                    config.setError("Error in editor. No changes saved");
                    this.fireError(config);
                }
                return;
            } else {
                LOG.warn((Object)("Received Onlyoffice error of saving document with several editors. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document " + nodePath));
                config.setError("Error in editor. Document still in editing state");
                this.fireError(config);
            }
            return;
        } else if (statusCode == 4L) {
            this.syncUsers(configs, status.getUsers());
            this.active.remove(key);
            this.active.remove(nodePath);
            return;
        } else {
            LOG.warn((Object)("Received Onlyoffice unexpected status. Key: " + key + ". URL: " + status.getUrl() + ". Users: " + status.getUsers() + ". Document " + nodePath));
        }
    }

    public void start() {
        LOG.info((Object)"Onlyoffice Editor service successfuly started");
    }

    public void stop() {
        this.active.clear();
        LOG.info((Object)"Onlyoffice  Editor service successfuly stopped");
    }

    protected String nodeTitle(Node node) throws RepositoryException {
        return node.getProperty("exo:title").getString();
    }

    protected String fileType(Node node) throws RepositoryException {
        String fileExt;
        String title = this.nodeTitle(node);
        int dotIndex = title.lastIndexOf(46);
        if (dotIndex >= 0 && dotIndex < title.length() && this.fileTypes.containsKey(fileExt = title.substring(dotIndex + 1).trim())) {
            return fileExt;
        }
        return null;
    }

    protected String documentType(String fileType) {
        String docType = this.fileTypes.get(fileType);
        if (docType != null) {
            return docType;
        }
        return TYPE_TEXT;
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }

    protected Calendar nodeCreated(Node node) throws RepositoryException {
        return node.getProperty("jcr:created").getDate();
    }

    protected String mimeType(Node content) throws RepositoryException {
        return content.getProperty("jcr:mimeType").getString();
    }

    protected Property data(Node content) throws RepositoryException {
        return content.getProperty("jcr:data");
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected String nodePath(String workspace, String path) {
        return workspace + ":" + path;
    }

    protected String nodePath(Config config) {
        return this.nodePath(config.getWorkspace(), config.getPath());
    }

    protected User getUser(String username) throws OnlyofficeEditorException {
        try {
            return this.organization.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            throw new OnlyofficeEditorException("Error searching user " + username, e);
        }
    }

    protected String webdavUrl(String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.baseWebdavUri.getPath());
        filePath.append('/');
        filePath.append(this.jcrService.getCurrentRepository().getConfiguration().getName());
        filePath.append('/');
        filePath.append(workspace);
        filePath.append(path);
        try {
            URI uri = new URI(this.baseWebdavUri.getScheme(), null, this.baseWebdavUri.getHost(), this.baseWebdavUri.getPort(), filePath.toString(), null, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new OnlyofficeEditorException("Error creating content link (WebDAV) for " + filePath, e);
        }
    }

    @Deprecated
    protected String uploadContent(InputStream localContent, String fileKey, String mimeType, long length) throws IOException, OnlyofficeEditorException {
        String urlTostorage = this.uploadUrl + this.uploadParams.format(new String[]{"", "", "", "", fileKey});
        URL url = new URL(urlTostorage);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", mimeType == null ? "application/octet-stream" : mimeType);
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", Long.toString(length));
        connection.setUseCaches(false);
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = localContent.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.flush();
        }
        InputStream uploadXml = connection.getInputStream();
        if (uploadXml == null) {
            throw new OnlyofficeEditorException("Could not get an answer from Onlyoffice Document Server for " + fileKey);
        }
        try {
            String responseUri;
            NodeList endConvert;
            DocumentBuilderFactory documentBuildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder doccumentBuilder = documentBuildFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(uploadXml);
            Document document = doccumentBuilder.parse(inputSource);
            Element responceFromConvertService = document.getDocumentElement();
            if (responceFromConvertService == null) {
                throw new OnlyofficeEditorException("Invalid answer format from Onlyoffice Document Server for " + fileKey);
            }
            NodeList errorElement = responceFromConvertService.getElementsByTagName("Error");
            if (errorElement != null && errorElement.getLength() > 0) {
                this.processConvertServiceResponceError(Integer.parseInt(errorElement.item(0).getTextContent()));
            }
            if ((endConvert = responceFromConvertService.getElementsByTagName("EndConvert")) == null || endConvert.getLength() == 0) {
                throw new OnlyofficeEditorException("Invalid answer format from Onlyoffice Document Server for " + fileKey);
            }
            Boolean isEndConvert = Boolean.parseBoolean(endConvert.item(0).getTextContent());
            int resultPercent = 0;
            if (isEndConvert.booleanValue()) {
                NodeList fileUrl = responceFromConvertService.getElementsByTagName("FileUrl");
                if (fileUrl == null || endConvert.getLength() == 0) {
                    throw new OnlyofficeEditorException("Invalid answer} format from Onlyoffice Document Server for " + fileKey);
                }
                resultPercent = 100;
                responseUri = fileUrl.item(0).getTextContent();
            } else {
                NodeList percent = responceFromConvertService.getElementsByTagName("Percent");
                if (percent != null && percent.getLength() > 0) {
                    resultPercent = Integer.parseInt(percent.item(0).getTextContent());
                }
                int n = resultPercent = resultPercent >= 100 ? 99 : resultPercent;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>> File not yet converted " + fileKey + ": " + resultPercent + "%"));
                }
                responseUri = null;
            }
            String string = responseUri;
            return string;
        }
        catch (ParserConfigurationException e) {
            throw new OnlyofficeEditorException("Error creating XML parser for reading upload response of " + fileKey, e);
        }
        catch (SAXException e) {
            throw new OnlyofficeEditorException("Error parsing answer from Onlyoffice Document Server for " + fileKey, e);
        }
        finally {
            connection.disconnect();
        }
    }

    private void processConvertServiceResponceError(int errorCode) throws OnlyofficeEditorException {
        String errorMessage = "";
        String errorMessageTemplate = "Error occurred in the ConvertService: ";
        switch (errorCode) {
            case -8: {
                errorMessage = errorMessageTemplate + "Error document VKey";
                break;
            }
            case -7: {
                errorMessage = errorMessageTemplate + "Error document request";
                break;
            }
            case -6: {
                errorMessage = errorMessageTemplate + "Error database";
                break;
            }
            case -5: {
                errorMessage = errorMessageTemplate + "Error unexpected guid";
                break;
            }
            case -4: {
                errorMessage = errorMessageTemplate + "Error download error";
                break;
            }
            case -3: {
                errorMessage = errorMessageTemplate + "Error convertation error";
                break;
            }
            case -2: {
                errorMessage = errorMessageTemplate + "Error convertation timeout";
                break;
            }
            case -1: {
                errorMessage = errorMessageTemplate + "Error convertation unknown";
                break;
            }
            case 0: {
                break;
            }
            default: {
                errorMessage = "ErrorCode = " + errorCode;
            }
        }
        throw new OnlyofficeEditorException(errorMessage);
    }

    protected void syncUsers(ConcurrentHashMap<String, Config> configs, String[] users) {
        HashSet<String> editors = new HashSet<String>(Arrays.asList(users));
        for (Map.Entry<String, Config> ce : configs.entrySet()) {
            String cuser = ce.getKey();
            Config config = ce.getValue();
            if (editors.contains(cuser)) {
                if (!config.isCreated() && !config.isClosed()) continue;
                config.open();
                this.fireJoined(config);
                continue;
            }
            if (!config.isOpen()) continue;
            config.close();
            this.fireLeaved(config);
        }
    }

    protected String[] getCurrentUsers(ConcurrentHashMap<String, Config> configs) {
        LinkedHashSet userIds = new LinkedHashSet(configs.keySet());
        Iterator uiter = userIds.iterator();
        while (uiter.hasNext()) {
            String userId = (String)uiter.next();
            Config config = configs.get(userId);
            if (config != null && !config.isCreated() && !config.isClosed()) continue;
            uiter.remove();
        }
        return userIds.toArray(new String[userIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(Config config, DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        InputStream data;
        HttpURLConnection connection;
        String workspace = config.getWorkspace();
        String path = config.getPath();
        String nodePath = this.nodePath(workspace, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> download(" + nodePath + ", " + config.getDocument().getKey() + ")"));
        }
        String userId = status.getUsers()[0];
        this.validateUser(userId, config);
        String contentUrl = status.getUrl();
        Calendar editedTime = Calendar.getInstance();
        try {
            URL url = new URL(contentUrl);
            connection = (HttpURLConnection)url.openConnection();
            data = connection.getInputStream();
            if (data == null) {
                throw new OnlyofficeEditorException("Content stream is null");
            }
        }
        catch (MalformedURLException e) {
            throw new OnlyofficeEditorException("Error parsing content URL " + contentUrl + " for " + nodePath, e);
        }
        catch (IOException e) {
            throw new OnlyofficeEditorException("Error reading content stream " + contentUrl + " for " + nodePath, e);
        }
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        try {
            Identity userIdentity = this.identityRegistry.getIdentity(userId);
            if (userIdentity == null) {
                LOG.warn((Object)("User identity not found " + userId + " for downloading " + config.getDocument().getKey() + " " + nodePath));
                throw new OnlyofficeEditorException("User identity not found " + userId);
            }
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            ConversationState.setCurrent((ConversationState)state);
            SessionProvider userProvider = new SessionProvider(state);
            this.sessionProviders.setSessionProvider(null, userProvider);
            Node node = this.node(workspace, path);
            Node content = this.nodeContent(node);
            Lock lock = this.lock(node, config);
            if (lock == null) {
                throw new OnlyofficeEditorException("Document locked " + nodePath);
            }
            boolean checkIn = this.checkout(node);
            try {
                content.setProperty("jcr:data", data);
                content.setProperty("jcr:lastModified", editedTime);
                if (content.hasProperty("exo:dateModified")) {
                    content.setProperty("exo:dateModified", editedTime);
                }
                if (content.hasProperty("exo:lastModifiedDate")) {
                    content.setProperty("exo:lastModifiedDate", editedTime);
                }
                if (node.hasProperty("exo:lastModifiedDate")) {
                    node.setProperty("exo:lastModifiedDate", editedTime);
                }
                if (node.hasProperty("exo:dateModified")) {
                    node.setProperty("exo:dateModified", editedTime);
                }
                if (node.hasProperty("exo:lastModifier")) {
                    node.setProperty("exo:lastModifier", userId);
                }
                node.save();
                if (checkIn) {
                    node.checkin();
                }
                config.close();
                this.fireSaved(config);
            }
            catch (RepositoryException e) {
                try {
                    node.refresh(false);
                }
                catch (Throwable re) {
                    LOG.warn((Object)("Error rolling back failed change for " + nodePath), re);
                }
                throw e;
            }
            finally {
                try {
                    data.close();
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error closing exported content stream for " + nodePath), e);
                }
                try {
                    connection.disconnect();
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error closing export connection for " + nodePath), e);
                }
                try {
                    if (lock != null && node.isLocked()) {
                        node.unlock();
                    }
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error unlocking edited document " + this.nodePath(workspace, path)), e);
                }
            }
        }
        finally {
            ConversationState.setCurrent((ConversationState)contextState);
            this.sessionProviders.setSessionProvider(null, contextProvider);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    protected void downloadChange(Config config) throws OnlyofficeEditorException, RepositoryException {
        InputStream data;
        HttpURLConnection connection;
        Node node;
        Node content;
        String workspace = config.getWorkspace();
        String path = config.getPath();
        String nodePath = this.nodePath(workspace, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> downloadChange(" + nodePath + ", " + config.getDocument().getKey() + ")"));
        }
        if (!(content = this.nodeContent(node = this.systemNode(workspace, path))).isNodeType("exo:editing")) throw new OnlyofficeEditorException("Document node was not initialized for editing " + nodePath);
        Property lastContentUrl = content.getProperty("exo:lastContentUrl");
        String contentUrl = lastContentUrl.getString();
        Property lastEditor = node.getProperty("exo:lastEditor");
        String editor = lastEditor.getString();
        Property lastEditedTime = content.getProperty("exo:lastEditedTime");
        Calendar editedTime = lastEditedTime.getDate();
        try {
            URL url = new URL(contentUrl);
            connection = (HttpURLConnection)url.openConnection();
            data = connection.getInputStream();
            if (data == null) {
                throw new OnlyofficeEditorException("Content stream is null");
            }
        }
        catch (MalformedURLException e) {
            throw new OnlyofficeEditorException("Error parsing content URL " + contentUrl + " for " + nodePath, e);
        }
        catch (IOException e) {
            throw new OnlyofficeEditorException("Error reading content stream " + contentUrl + " for " + nodePath, e);
        }
        Lock lock = this.lock(node, config);
        if (lock == null) {
            throw new OnlyofficeEditorException("Document locked " + nodePath);
        }
        boolean checkIn = this.checkout(node);
        try {
            content.setProperty("jcr:data", data);
            content.setProperty("jcr:lastModified", editedTime);
            if (content.hasProperty("exo:dateModified")) {
                content.setProperty("exo:dateModified", editedTime);
            }
            if (content.hasProperty("exo:lastModifiedDate")) {
                content.setProperty("exo:lastModifiedDate", editedTime);
            }
            if (node.hasProperty("exo:lastModifiedDate")) {
                node.setProperty("exo:lastModifiedDate", editedTime);
            }
            if (node.hasProperty("exo:dateModified")) {
                node.setProperty("exo:dateModified", editedTime);
            }
            if (node.hasProperty("exo:lastModifier")) {
                node.setProperty("exo:lastModifier", editor);
            }
            lastContentUrl.remove();
            lastEditor.remove();
            lastEditedTime.remove();
            content.removeMixin("exo:editing");
            node.save();
            if (!checkIn) return;
            node.checkin();
            return;
        }
        catch (RepositoryException e) {
            try {
                node.refresh(false);
                throw e;
            }
            catch (Throwable re) {
                LOG.warn((Object)("Error rolling back failed change for " + nodePath), re);
            }
            throw e;
        }
        finally {
            try {
                data.close();
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error closing exported content stream for " + nodePath), e);
            }
            try {
                connection.disconnect();
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error closing export connection for " + nodePath), e);
            }
            try {
                if (lock != null && node.isLocked()) {
                    node.unlock();
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error unlocking edited document " + this.nodePath(workspace, path)), e);
            }
        }
    }

    @Deprecated
    protected void trackChange(Config config, DocumentStatus status) throws BadParameterException, OnlyofficeEditorException, RepositoryException {
        Node content;
        String user;
        String workspace = config.getWorkspace();
        String path = config.getPath();
        String contentUrl = status.getUrl();
        String[] users = status.getUsers();
        if (users != null && users.length > 0) {
            user = users[0];
        } else {
            LOG.warn((Object)("No user in status from Onlyoffice document editing service for file " + status.getKey() + " (" + this.nodePath(workspace, path) + ")"));
            user = null;
        }
        if (contentUrl != null && contentUrl.length() > 0) {
            Node node = this.systemNode(workspace, path);
            this.checkout(node);
            content = this.nodeContent(node);
            if (content.canAddMixin("exo:editing")) {
                content.addMixin("exo:editing");
                content.save();
            }
        } else {
            throw new OnlyofficeEditorException("Empty link to the edited document from editing service. User " + user + ". Document " + this.nodePath(workspace, path));
        }
        content.setProperty("exo:lastContentUrl", contentUrl);
        content.setProperty("exo:lastEditor", user);
        content.setProperty("exo:lastEditedTime", Calendar.getInstance());
        content.save();
    }

    protected Node node(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(userSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node systemNode(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSystemSessionProvider(null);
        Session sysSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(sysSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected Version checkin(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable") && node.isCheckedOut()) {
            return node.checkin();
        }
        return null;
    }

    protected Lock lock(Node node, Config config) throws OnlyofficeEditorException, RepositoryException {
        Lock lock;
        if (!node.isNodeType("mix:lockable")) {
            if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                node.checkout();
            }
            node.addMixin("mix:lockable");
            node.save();
        }
        Config.Editor.User user = config.getEditorConfig().getUser();
        int attempts = 0;
        try {
            do {
                ++attempts;
                if (node.isLocked()) {
                    String lockToken = user.getLockToken();
                    if (node.getLock().getLockOwner().equals(user.getId()) && lockToken != null) {
                        node.getSession().addLockToken(lockToken);
                        lock = node.getLock();
                        continue;
                    }
                    Thread.sleep(250L);
                    lock = null;
                    continue;
                }
                lock = node.lock(true, false);
                user.setLockToken(lock.getLockToken());
            } while (lock == null && attempts <= 20);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OnlyofficeEditorException("Error waiting for lock of " + this.nodePath(config.getWorkspace(), config.getPath()), e);
        }
        return lock;
    }

    @Deprecated
    protected boolean unlock(Node node, Config config) throws OnlyofficeEditorException, RepositoryException {
        if (node.isLocked()) {
            Config.Editor.User user = config.getEditorConfig().getUser();
            String lockToken = user.getLockToken();
            if (node.getLock().getLockOwner().equals(user.getId()) && lockToken != null) {
                node.getSession().addLockToken(lockToken);
                node.unlock();
                return true;
            }
        }
        return false;
    }

    protected void validateUser(String userId, Config config) throws OnlyofficeEditorException {
        User user = this.getUser(userId);
        if (user == null) {
            LOG.warn((Object)("Attempt to access editor document (" + this.nodePath(config) + ") under not existing user " + userId));
            throw new BadParameterException("User not found for " + config.getDocument().getTitle());
        }
    }

    protected String getUserLang(String userId) throws OnlyofficeEditorException {
        UserProfileHandler hanlder = this.organization.getUserProfileHandler();
        try {
            UserProfile userProfile = hanlder.findUserProfileByName(userId);
            if (userProfile != null) {
                String lang = userProfile.getAttribute("user.language");
                if (lang != null) {
                    int cci = lang.indexOf("_");
                    if (cci > 0) {
                        lang = lang.substring(0, cci);
                    }
                } else {
                    lang = Locale.ENGLISH.getLanguage();
                }
                return lang;
            }
            throw new BadParameterException("User profile not found for " + userId);
        }
        catch (Exception e) {
            throw new OnlyofficeEditorException("Error searching user profile " + userId, e);
        }
    }

    protected void fireCreated(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onCreate(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Creation listener error", t);
            }
        }
    }

    protected void fireGet(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onGet(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Read (Get) listener error", t);
            }
        }
    }

    protected void fireJoined(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onJoined(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User joining listener error", t);
            }
        }
    }

    protected void fireLeaved(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onLeaved(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User leaving listener error", t);
            }
        }
    }

    protected void fireSaved(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onSaved(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Saving listener error", t);
            }
        }
    }

    protected void fireError(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onError(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Error listener error", t);
            }
        }
    }
}

