/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={RefreshViewActionListener.class})})
public class RefreshViewManagerComponent
extends UIAbstractManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(RefreshViewManagerComponent.class);
    public static final String EVENT_NAME = "RefreshView";

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        if (EVENT_NAME.equals(name)) {
            this.initContext(PortalRequestContext.getCurrentInstance());
        }
        return super.renderEventURL(ajax, name, beanId, params);
    }

    protected void initContext(RequestContext context) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer != null) {
            String path = uiExplorer.getCurrentNode().getPath();
            String string = uiExplorer.getCurrentNode().getSession().getWorkspace().getName();
        } else {
            LOG.error((Object)("Cannot find ancestor of type UIJCRExplorer in component " + (Object)((Object)this) + ", parent: " + this.getParent()));
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class RefreshViewActionListener
    extends EventListener<RefreshViewManagerComponent> {
        public void execute(Event<RefreshViewManagerComponent> event) throws Exception {
            UIAddressBar addressBar;
            UIJCRExplorer explorer = (UIJCRExplorer)((RefreshViewManagerComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            explorer.getSession().refresh(false);
            explorer.refreshExplorer();
            UIWorkingArea workingArea = (UIWorkingArea)explorer.getChild(UIWorkingArea.class);
            UIActionBar actionBar = (UIActionBar)workingArea.getChild(UIActionBar.class);
            UIControl control = (UIControl)explorer.getChild(UIControl.class);
            if (control != null && (addressBar = (UIAddressBar)control.getChild(UIAddressBar.class)) != null) {
                actionBar.setTabOptions(addressBar.getSelectedViewName());
            }
        }
    }
}

