/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.onlyoffice.webui.CanShowOnlyofficeFilter;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorContext;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorUIService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/templates/OnlyofficeEditor.gtmpl", events={@EventConfig(listeners={OnCloseActionListener.class}), @EventConfig(listeners={OnErrorActionListener.class})})
public class OnlyofficeEditor
extends UIForm {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditor.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new CanShowOnlyofficeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Deprecated
    protected void initContext(RequestContext context) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer != null) {
            String path = uiExplorer.getCurrentNode().getPath();
            String workspace = uiExplorer.getCurrentNode().getSession().getWorkspace().getName();
            OnlyofficeEditorContext.init(context, workspace, path);
            OnlyofficeEditorUIService editorsUI = (OnlyofficeEditorUIService)WCMCoreUtils.getService(OnlyofficeEditorUIService.class);
            if (editorsUI.isOpen(context.getRemoteUser(), workspace, path)) {
                OnlyofficeEditorContext.open(context);
            }
        } else {
            LOG.error((Object)("Cannot find ancestor of type UIJCRExplorer in component " + (Object)((Object)this) + ", parent: " + this.getParent()));
        }
    }

    public String getId() {
        String id = super.getId();
        if (id == null) {
            id = ((Object)((Object)this)).getClass().getSimpleName();
        }
        return id;
    }

    public static class OnErrorActionListener
    extends EventListener<OnlyofficeEditor> {
        public void execute(Event<OnlyofficeEditor> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIJCRExplorer explorer = (UIJCRExplorer)((OnlyofficeEditor)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            explorer.getSession().refresh(false);
            String workspace = explorer.getCurrentWorkspace();
            String path = explorer.getCurrentNode().getPath();
            OnlyofficeEditorUIService editorsUI = (OnlyofficeEditorUIService)WCMCoreUtils.getService(OnlyofficeEditorUIService.class);
            editorsUI.reset(context.getRemoteUser(), workspace, path);
            OnlyofficeEditorContext.init((RequestContext)context, workspace, path);
        }
    }

    public static class OnCloseActionListener
    extends EventListener<OnlyofficeEditor> {
        public void execute(Event<OnlyofficeEditor> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIJCRExplorer explorer = (UIJCRExplorer)((OnlyofficeEditor)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            explorer.getSession().refresh(false);
            String workspace = explorer.getCurrentWorkspace();
            String path = explorer.getCurrentNode().getPath();
            OnlyofficeEditorUIService editorsUI = (OnlyofficeEditorUIService)WCMCoreUtils.getService(OnlyofficeEditorUIService.class);
            editorsUI.closed(context.getRemoteUser(), workspace, path);
            OnlyofficeEditorContext.init((RequestContext)context, workspace, path);
        }
    }
}

