/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UserInfo {
    protected static final Log LOG = ExoLogger.getLogger(UserInfo.class);
    private final String name;
    private final String firstName;
    private final String lastName;
    private final Map<String, List<IMInfo>> imAccounts = new HashMap<String, List<IMInfo>>();

    public UserInfo(String userName, String firstName, String lastName) {
        this.name = userName;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getName() {
        return this.name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Map<String, Collection<IMInfo>> getImAccounts() {
        return Collections.unmodifiableMap(this.imAccounts);
    }

    public IMInfo addImAccount(String type, String id) {
        IMInfo im = new IMInfo(type, id);
        this.imAccounts.computeIfAbsent(type, list -> new ArrayList()).add(im);
        return im;
    }

    public void addImAccount(IMInfo ... ims) {
        for (IMInfo im : ims) {
            this.imAccounts.computeIfAbsent(im.getType(), list -> new ArrayList()).add(im);
        }
    }

    public boolean hasImAccount(String type) {
        return this.imAccounts.containsKey(type);
    }

    public Collection<IMInfo> getImAccount(String type) {
        return Collections.unmodifiableCollection((Collection)this.imAccounts.get(type));
    }

    public static class IMInfo {
        private final String type;
        private final String id;

        protected IMInfo(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

