/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.skype;

import java.util.List;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsProviderException;
import org.exoplatform.videocalls.skype.SkypeProvider;
import org.exoplatform.videocalls.skype.SkypeSettings;

public class SkypeBusinessProvider
extends SkypeProvider {
    public static final String CONFIG_AUTODISCOVER_ORIGINS = "autodiscover-origins";
    public static final String CONFIG_WEB_APPVERSION = "web-oauth2-appVersion";
    public static final String CONFIG_WEB_OAUTH2_URL = "web-oauth2-loginUri";
    public static final String CONFIG_WEB_OAUTH2_CLIENTID = "web-oauth2-clientId";
    public static final String CONFIG_WEB_APIKEY = "web-apiKey";
    public static final String CONFIG_WEB_APIKEYCC = "web-apiKeyCC";
    public static final String SFB_SCHEMA = "ms-sfb";
    public static final String SFB_TYPE = "mssfb";
    public static final String SFB_TITLE = "Skype for Business";
    public static final String SFB_AUTODISCOVER_ORIGINS_DEFAULT = "https://webdir.online.lync.com/AutoDiscover/AutoDiscoverservice.svc/root";
    protected final String loginUrl;
    protected final String clientId;
    protected final String apiKey;
    protected final String apiKeyCC;
    protected final String[] origins;
    protected final String version;

    public SkypeBusinessProvider(InitParams params) throws ConfigurationException {
        this(null, params);
    }

    public SkypeBusinessProvider(UserProfileSettingsService profileSettings, InitParams params) throws ConfigurationException {
        super(params);
        String version = (String)this.config.get(CONFIG_WEB_APPVERSION);
        if (version == null || (version = version.trim()).length() == 0) {
            throw new ConfigurationException("web-oauth2-appVersion required and should be non empty.");
        }
        this.version = version;
        String loginUrl = (String)this.config.get(CONFIG_WEB_OAUTH2_URL);
        if (loginUrl == null || (loginUrl = loginUrl.trim()).length() == 0) {
            throw new ConfigurationException("web-oauth2-loginUri required and should be non empty.");
        }
        this.loginUrl = loginUrl;
        String clientId = (String)this.config.get(CONFIG_WEB_OAUTH2_CLIENTID);
        if (clientId == null || (clientId = clientId.trim()).length() == 0) {
            throw new ConfigurationException("web-oauth2-clientId required and should be non empty.");
        }
        this.clientId = clientId;
        String apiKey = (String)this.config.get(CONFIG_WEB_APIKEY);
        if (apiKey == null || (apiKey = apiKey.trim()).length() == 0) {
            throw new ConfigurationException("web-apiKey required and should be non empty.");
        }
        this.apiKey = apiKey;
        String apiKeyCC = (String)this.config.get(CONFIG_WEB_APIKEYCC);
        if (apiKeyCC == null || (apiKeyCC = apiKeyCC.trim()).length() == 0) {
            throw new ConfigurationException("web-apiKeyCC required and should be non empty.");
        }
        this.apiKeyCC = apiKeyCC;
        ValuesParam originsParams = params.getValuesParam(CONFIG_AUTODISCOVER_ORIGINS);
        if (originsParams != null) {
            List values = originsParams.getValues();
            this.origins = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                this.origins[i] = (String)values.get(i);
            }
        } else {
            this.origins = new String[]{SFB_AUTODISCOVER_ORIGINS_DEFAULT};
        }
        if (profileSettings != null) {
            profileSettings.addIMType(new IMType(SFB_TYPE, SFB_TITLE));
        }
    }

    @Override
    public WebSettingsBuilder getSettings() {
        return new WebSettingsBuilder();
    }

    public String[] getOrigins() {
        String[] copy = new String[this.origins.length];
        System.arraycopy(this.origins, 0, copy, 0, this.origins.length);
        return copy;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiKeyCC() {
        return this.apiKeyCC;
    }

    @Override
    public UserInfo.IMInfo getIMInfo(String imId) throws VideoCallsProviderException {
        return new SkypeBusinessIMInfo(imId);
    }

    @Override
    public String getType() {
        return SFB_TYPE;
    }

    @Override
    public String getTitle() {
        return SFB_TITLE;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public class SkypeBusinessIMInfo
    extends SkypeProvider.SkypeIMInfo {
        protected SkypeBusinessIMInfo(String id) {
            super(SkypeBusinessProvider.SFB_TYPE, id);
        }

        @Override
        public String getSchema() {
            return SkypeBusinessProvider.SFB_SCHEMA;
        }

        @Override
        public boolean isBusiness() {
            return true;
        }
    }

    public class WebSettingsBuilder
    extends SkypeProvider.SettingsBuilder {
        @Override
        public SkypeSettings build() {
            return new SkypeSettings(SkypeBusinessProvider.this.getType(), SkypeBusinessProvider.this.getSupportedTypes(), SkypeBusinessProvider.this.getTitle(), "Call", SkypeBusinessProvider.this.getClientId(), this.redirectURI, SkypeBusinessProvider.this.getVersion(), SkypeBusinessProvider.this.getApiKey(), SkypeBusinessProvider.this.getApiKeyCC(), SkypeBusinessProvider.this.origins);
        }
    }
}

