/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.skype.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.videocalls.ContextInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.VideoCallsUtils;
import org.exoplatform.videocalls.skype.SkypeBusinessProvider;
import org.exoplatform.videocalls.skype.SkypeSettings;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class SkypeCallServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -6075521943684342591L;
    protected static final Logger LOG = LoggerFactory.getLogger(SkypeCallServlet.class);
    private static final String CALL_PAGE = "/WEB-INF/pages/call.jsp";
    private static final String UNAUTHORIZED_PAGE = "/WEB-INF/pages/unauthorized.html";
    private static final String SERVER_ERROR_PAGE = "/WEB-INF/pages/servererror.html";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequest httpReq = req;
        HttpServletResponse httpRes = resp;
        Object redirectUri = httpReq.getAttribute("skypecall_redirect");
        if (redirectUri != null) {
            String ruri = (String)redirectUri;
            if (ruri.length() > 0) {
                httpRes.sendRedirect(ruri);
            }
        } else {
            httpRes.setContentType("text/html; charset=UTF-8");
            String remoteUser = httpReq.getRemoteUser();
            ExoContainer container = this.getContainer();
            VideoCallsService videoCalls = (VideoCallsService)container.getComponentInstanceOfType(VideoCallsService.class);
            if (videoCalls != null) {
                SkypeBusinessProvider provider;
                try {
                    provider = (SkypeBusinessProvider)videoCalls.getProvider("mssfb");
                }
                catch (ClassCastException e) {
                    LOG.error((Object)("Provider mssfb isn't an instance of " + SkypeBusinessProvider.class.getName()), (Throwable)e);
                    provider = null;
                }
                if (provider != null) {
                    try {
                        req.setCharacterEncoding("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Object)"Encoding not supported", (Throwable)e);
                    }
                    if (remoteUser != null) {
                        try {
                            ContextInfo context = VideoCallsUtils.getCurrentContext();
                            httpReq.setAttribute("spaceInfo", (Object)VideoCallsUtils.asJSON((Object)context));
                            UserInfo exoUser = videoCalls.getUserInfo(remoteUser);
                            httpReq.setAttribute("userInfo", (Object)VideoCallsUtils.asJSON((Object)exoUser));
                            URI redirectURI = new URI(httpReq.getScheme(), null, httpReq.getServerName(), httpReq.getServerPort(), "/portal/skype/call", null, null);
                            SkypeSettings settings = provider.getSettings().redirectURI(redirectURI.toString()).build();
                            httpReq.setAttribute("settings", (Object)VideoCallsUtils.asJSON((Object)settings));
                            httpReq.getRequestDispatcher(CALL_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error processing Skype call page", (Throwable)e);
                            httpRes.setStatus(500);
                            httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                        }
                    } else {
                        httpRes.setStatus(401);
                        httpReq.getRequestDispatcher(UNAUTHORIZED_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                    }
                } else {
                    LOG.error((Object)("Skype provider not found for call page and user " + remoteUser));
                    httpRes.setStatus(500);
                    httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                }
            } else {
                LOG.error((Object)("Video Calls service not found for call page and user " + remoteUser));
                httpRes.setStatus(500);
                httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

