/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.videocalls.IdentityInfo;
import org.exoplatform.videocalls.UserInfo;

public class CallInfo {
    protected final String id;
    protected final String title;
    protected final Set<UserInfo> participants = new LinkedHashSet<UserInfo>();
    protected final IdentityInfo owner;
    protected final String ownerType;
    protected final String ownerLink;
    protected final String avatarLink;

    public CallInfo(String id, String title, IdentityInfo owner, String ownerType, String ownerLink, String avatarLink) {
        this.id = id;
        this.title = title;
        this.owner = owner;
        this.ownerType = ownerType;
        this.ownerLink = ownerLink;
        this.avatarLink = avatarLink;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<UserInfo> getParticipants() {
        return this.participants;
    }

    public IdentityInfo getOwner() {
        return this.owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getOwnerLink() {
        return this.ownerLink;
    }

    public String getAvatarLink() {
        return this.avatarLink;
    }

    public void addParticipants(Collection<UserInfo> parts) {
        this.participants.addAll(parts);
    }

    public void addParticipant(UserInfo part) {
        this.participants.add(part);
    }
}

