/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsProviderException;

public abstract class VideoCallsProvider
extends BaseComponentPlugin {
    public static final String CONFIG_PROVIDER_TYPE = "type";
    public static final String CONFIG_PROVIDER_NAME = "name";
    public static final String CONFIG_PROVIDER_CONFIGURATION = "provider-configuration";
    protected static final String EMAIL_REGEX = "^(?=[A-Z0-9][A-Z0-9@._%+-]{5,253}+$)[A-Z0-9._%+-]{1,64}+@(?:(?=[A-Z0-9-]{1,63}+\\.)[A-Z0-9]++(?:-[A-Z0-9]++)*+\\.){1,8}+[A-Z]{2,63}+$";
    protected final Pattern emailTest = Pattern.compile("^(?=[A-Z0-9][A-Z0-9@._%+-]{5,253}+$)[A-Z0-9._%+-]{1,64}+@(?:(?=[A-Z0-9-]{1,63}+\\.)[A-Z0-9]++(?:-[A-Z0-9]++)*+\\.){1,8}+[A-Z]{2,63}+$", 34);
    protected final Map<String, String> config;

    public VideoCallsProvider(InitParams params) throws ConfigurationException {
        PropertiesParam param = params.getPropertiesParam(CONFIG_PROVIDER_CONFIGURATION);
        if (param == null) {
            throw new ConfigurationException("Property parameters provider-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
    }

    public abstract String getTitle();

    public abstract String getVersion();

    public abstract String getType();

    public boolean isSupportedType(String type) {
        return this.getType().equals(type);
    }

    public abstract String[] getSupportedTypes();

    public abstract UserInfo.IMInfo getIMInfo(String var1) throws VideoCallsProviderException;
}

