/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.videocalls.ContextInfo;
import org.exoplatform.videocalls.IdentityInfo;
import org.exoplatform.videocalls.cometd.CometdVideoCallsService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class VideoCallsUtils {
    public static String spaceRoomName(String spacePrettyName) {
        StringBuilder sname = new StringBuilder();
        sname.append("eXoVideoCalls");
        for (String s : spacePrettyName.split("_")) {
            if (s.length() <= 0) continue;
            sname.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sname.append(s.substring(1));
        }
        sname.append("Space");
        return sname.toString();
    }

    public static Space getSpaceByContext() {
        String spacePrettyName;
        SpaceService spaceService;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (spaceService = (SpaceService)webuiContext.getUIApplication().getApplicationComponent(SpaceService.class)) != null && (spacePrettyName = VideoCallsUtils.getSpaceNameByContext()) != null) {
            return spaceService.getSpaceByPrettyName(spacePrettyName);
        }
        return null;
    }

    public static String getSpaceNameByContext() {
        PortalRequestContext portlalContext;
        String requestPath;
        ExoRouter.Route route;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (route = ExoRouter.route((String)(requestPath = (portlalContext = webuiContext instanceof PortalRequestContext ? (PortalRequestContext)webuiContext : (PortalRequestContext)webuiContext.getParentAppRequestContext()).getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH)))) != null && portlalContext.getSiteType().equals((Object)SiteType.GROUP) && portlalContext.getSiteName().startsWith("/spaces")) {
            return (String)route.localArgs.get("spacePrettyName");
        }
        return null;
    }

    public static ContextInfo getCurrentContext(String userId) {
        String spaceRoomName;
        String spacePrettyName = VideoCallsUtils.getSpaceNameByContext();
        if (spacePrettyName != null) {
            spaceRoomName = VideoCallsUtils.spaceRoomName(spacePrettyName);
        } else {
            spacePrettyName = spaceRoomName = IdentityInfo.EMPTY;
        }
        ExoContainer exo = ExoContainerContext.getCurrentContainer();
        CometdVideoCallsService cometdService = (CometdVideoCallsService)exo.getComponentInstanceOfType(CometdVideoCallsService.class);
        if (cometdService != null) {
            return new ContextInfo(exo.getContext().getName(), spacePrettyName, spaceRoomName, cometdService.getCometdServerPath(), cometdService.getUserToken(userId));
        }
        return new ContextInfo(exo.getContext().getName(), spacePrettyName, spaceRoomName);
    }

    public static String asJSON(Object obj) throws JsonException {
        if (obj != null) {
            JsonGeneratorImpl gen = new JsonGeneratorImpl();
            if (obj.getClass().isArray()) {
                return gen.createJsonArray(obj).toString();
            }
            return gen.createJsonObject(obj).toString();
        }
        return "null".intern();
    }
}

