/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.rest.response.FunctionalConfiguration;
import org.exoplatform.rest.response.HighlightSpaceConfiguration;
import org.exoplatform.rest.response.SpaceConfiguration;
import org.exoplatform.service.exception.FunctionalConfigurationRuntimeException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class FunctionalConfigurationService {
    private static final Log LOGGER = ExoLogger.getLogger(FunctionalConfigurationService.class);
    static final String HIDE_DOCUMENT_ACTION_ACTIVITIES = "HIDE_DOCUMENT_ACTION_ACTIVITIES";
    public static final String HIDE_USER_ACTIVITY_COMPOSER = "hideUserActivityComposer";
    public static final String SPACES_WITHOUT_ACTIVITY_COMPOSER = "spacesWithoutActivityComposer";
    public static final String HIGHLIGHT_SPACES = "highlightspaces";
    public static final String HIGHLIGHT_SPACES_SEPARATOR = "#";
    private static final String SETTINGS_SEPARATOR = ";";
    private SettingService settingService;
    private List<Space> listSpacesWithActivityComposer;
    private List<Space> listSpacesWithoutActivityComposer;
    private SpaceService spaceService;

    public FunctionalConfigurationService(SettingService settingService, SpaceService spaceService) {
        this.settingService = settingService;
        this.spaceService = spaceService;
    }

    public List<Space> getListSpacesWithActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithActivityComposer;
    }

    public List<Space> getListSpacesWithoutActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithoutActivityComposer;
    }

    public String getUserActivityComposerState() {
        SettingValue hideUserActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER);
        return hideUserActivityComposerSetting != null ? (String)hideUserActivityComposerSetting.getValue() : "false";
    }

    public void hideSpaceActivityComposer(String spaces) {
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)(spacesWithoutActivityComposer + (spaces.startsWith(",") ? spaces.substring(0).replace(",", SETTINGS_SEPARATOR) : spaces.replace(",", SETTINGS_SEPARATOR)) + SETTINGS_SEPARATOR)));
    }

    public void showSpaceActivityComposer(String spaces) {
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)spacesWithoutActivityComposer.replace((spaces.startsWith(",") ? spaces.substring(0).replace(",", SETTINGS_SEPARATOR) : spaces.replace(",", SETTINGS_SEPARATOR)) + SETTINGS_SEPARATOR, "")));
    }

    private void initSpaces() throws Exception {
        ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
        Space[] allSpaces = (Space[])allSpacesListAccess.load(0, allSpacesListAccess.getSize());
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        List<String> spacesWithoutList = Arrays.asList(spacesWithoutActivityComposer.split(SETTINGS_SEPARATOR));
        this.listSpacesWithoutActivityComposer = new ArrayList<Space>();
        this.listSpacesWithActivityComposer = new ArrayList<Space>();
        for (Space space : allSpaces) {
            if (!spacesWithoutActivityComposer.isEmpty() && spacesWithoutList.contains(space.getId())) {
                this.listSpacesWithoutActivityComposer.add(space);
                continue;
            }
            this.listSpacesWithActivityComposer.add(space);
        }
    }

    private List<SpaceConfiguration> findSpaceConfigurations() {
        ArrayList<SpaceConfiguration> spaceConfigurations = new ArrayList<SpaceConfiguration>();
        for (Space space : this.findAllSpaces()) {
            SpaceConfiguration spaceConfiguration = new SpaceConfiguration();
            Map<String, Integer> highlightConfigurationMap = this.loadHighlightConfigAsMap();
            Set<String> activityComposerConfiguration = this.loadActivityComposerConfigurationAsSet();
            boolean hideActivityComposer = activityComposerConfiguration.stream().anyMatch(f -> space.getId().equals(f));
            spaceConfiguration.setId(space.getId());
            spaceConfiguration.setDisplayName(space.getDisplayName());
            spaceConfiguration.setDescription(space.getDescription());
            spaceConfiguration.setActivityComposerVisible(!hideActivityComposer);
            HighlightSpaceConfiguration highlightConfiguration = new HighlightSpaceConfiguration();
            if (highlightConfigurationMap.containsKey(space.getId())) {
                highlightConfiguration.setHighlight(true);
                highlightConfiguration.setOrder(highlightConfigurationMap.get(space.getId()));
            } else {
                highlightConfiguration.setHighlight(false);
            }
            spaceConfiguration.setHighlightConfiguration(highlightConfiguration);
            spaceConfigurations.add(spaceConfiguration);
        }
        return spaceConfigurations;
    }

    protected List<Space> findAllSpaces() {
        try {
            ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
            return Arrays.asList(allSpacesListAccess.load(0, allSpacesListAccess.getSize()));
        }
        catch (Exception e) {
            throw new FunctionalConfigurationRuntimeException("space.error.loading");
        }
    }

    public void configureActivityComposer(String hide) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER, SettingValue.create((String)hide));
    }

    public void configureDocumentActionActivities(String hidden) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, HIDE_DOCUMENT_ACTION_ACTIVITIES, SettingValue.create((String)hidden));
    }

    public FunctionalConfiguration getConfiguration() {
        FunctionalConfiguration configuration = new FunctionalConfiguration();
        configuration.setHideComposerActivities(this.isActivityComposerHidden());
        configuration.setHideDocumentActionActivities(this.isDocumentActionActivityHidden());
        configuration.setSpaceConfigurations(this.findSpaceConfigurations());
        return configuration;
    }

    public boolean isDocumentActionActivityHidden() {
        return this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_DOCUMENT_ACTION_ACTIVITIES));
    }

    private boolean isActivityComposerHidden() {
        return this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER));
    }

    private boolean getSettingValueAsBoolean(SettingValue<?> settingValue) {
        if (Objects.isNull(settingValue) || Objects.isNull(settingValue.getValue()) || StringUtils.isEmpty((CharSequence)settingValue.getValue().toString())) {
            return false;
        }
        return Boolean.valueOf(settingValue.getValue().toString());
    }

    public SpaceConfiguration updateSpaceConfiguration(SpaceConfiguration spaceConfiguration) {
        Space space = this.spaceService.getSpaceById(spaceConfiguration.getId());
        if (Objects.isNull(space)) {
            LOGGER.error((Object)("Space with id : " + spaceConfiguration.getId() + " NOT FOUND"));
            throw new FunctionalConfigurationRuntimeException("space.notfound");
        }
        Map<String, Integer> highlightConfigurationsMap = this.loadHighlightConfigAsMap();
        this.updateAndSaveHighlightConfigurationMap(space, spaceConfiguration.getHighlightConfiguration(), highlightConfigurationsMap);
        Set<String> activityComposerConfigurations = this.loadActivityComposerConfigurationAsSet();
        this.updateAndSaveActivityComposerConfigurationSet(spaceConfiguration, space, activityComposerConfigurations);
        return spaceConfiguration;
    }

    private void updateAndSaveActivityComposerConfigurationSet(SpaceConfiguration spaceConfiguration, Space space, Set<String> activityComposerConfigurations) {
        String spaceId = space.getId();
        if (!spaceConfiguration.isActivityComposerVisible()) {
            activityComposerConfigurations.add(spaceId);
        } else {
            activityComposerConfigurations = activityComposerConfigurations.stream().filter(configuration -> !StringUtils.equals((CharSequence)spaceId, (CharSequence)configuration)).collect(Collectors.toSet());
        }
        this.parseAndSaveSettings(SPACES_WITHOUT_ACTIVITY_COMPOSER, new ArrayList<String>(activityComposerConfigurations));
    }

    private void updateAndSaveHighlightConfigurationMap(Space space, HighlightSpaceConfiguration highlightConfiguration, Map<String, Integer> highlightConfigurations) {
        String spaceId = space.getId();
        if (highlightConfiguration.isHighlight()) {
            if (!highlightConfigurations.containsKey(spaceId)) {
                highlightConfigurations.put(spaceId, null);
            }
            highlightConfigurations.put(spaceId, highlightConfiguration.getOrder());
        } else {
            highlightConfigurations.remove(spaceId);
        }
        this.saveHighlightConfiguration(highlightConfigurations);
    }

    private void saveHighlightConfiguration(Map<String, Integer> highlightConfigurationsAsMap) {
        List<String> highlightConfigurationsAsList = highlightConfigurationsAsMap.entrySet().stream().map(entry -> (String)entry.getKey() + HIGHLIGHT_SPACES_SEPARATOR + entry.getValue()).collect(Collectors.toList());
        this.parseAndSaveSettings(HIGHLIGHT_SPACES, highlightConfigurationsAsList);
    }

    private void parseAndSaveSettings(String settingKey, List<String> configurations) {
        String settingsAsString = configurations.stream().collect(Collectors.joining(SETTINGS_SEPARATOR, "", ""));
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, settingKey, SettingValue.create((String)settingsAsString));
    }

    private Set<String> loadActivityComposerConfigurationAsSet() {
        return new HashSet<String>(this.loadAndParseSettings(SPACES_WITHOUT_ACTIVITY_COMPOSER));
    }

    public Map<String, Integer> loadHighlightConfigAsMap() {
        List<String> settings = this.loadAndParseSettings(HIGHLIGHT_SPACES);
        return this.convertHighlightSpacesConfigurationsFromListToMap(settings);
    }

    private Map<String, Integer> convertHighlightSpacesConfigurationsFromListToMap(List<String> highlightSpacesConfigurationsAsList) {
        int HIGHLIGHT_SPACES_CONFIGURATION_LENGTH = 2;
        HashMap<String, Integer> configurationAsMap = new HashMap<String, Integer>();
        for (String configuration : highlightSpacesConfigurationsAsList) {
            String[] split = configuration.split(HIGHLIGHT_SPACES_SEPARATOR);
            if (2 != split.length) continue;
            configurationAsMap.put(split[0], Integer.valueOf(split[1]));
        }
        return configurationAsMap;
    }

    private List<String> loadAndParseSettings(String settingKey) {
        String settingsAsString = this.loadSettingsAsString(settingKey);
        return StringUtils.isNotEmpty((CharSequence)settingsAsString) ? Arrays.asList(settingsAsString.split(SETTINGS_SEPARATOR)) : new ArrayList();
    }

    private String loadSettingsAsString(String highlightSpaces) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, highlightSpaces);
        return Objects.nonNull(settingValue) ? (String)settingValue.getValue() : "";
    }
}

