/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest;

import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.rest.response.SpaceConfiguration;
import org.exoplatform.rest.utils.RestUtils;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/functional-configuration")
public class FunctionalConfigurationController
implements ResourceContainer {
    private static final String DOCUMENT_ACTIVITY_ENDPOINT = "/document-activity";
    private static final String CONFIGURATION_ENDPOINT = "/configuration";
    private static final String COMPOSER_ACTIVITY_ENDPOINT = "/composer-activity";
    private static final String UPDATE_SPACE_CONFIGURATION_ENDPOINT = "/configuration/space";
    private FunctionalConfigurationService functionalConfigurationService;

    public FunctionalConfigurationController(FunctionalConfigurationService functionalConfigurationService) {
        this.functionalConfigurationService = functionalConfigurationService;
    }

    @GET
    @Path(value="/configuration")
    public Response getConfiguration() {
        return Response.ok((Object)this.functionalConfigurationService.getConfiguration(), (String)"application/json").build();
    }

    @PUT
    @Path(value="/document-activity")
    public Response updateDocumentActionActivitiesVisibility(@QueryParam(value="hidden") String hidden) {
        if (!RestUtils.isValidBooleanParameter(hidden)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.functionalConfigurationService.configureDocumentActionActivities(hidden);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/composer-activity")
    public Response updateComposerActivity(@QueryParam(value="hidden") String hidden) {
        if (!RestUtils.isValidBooleanParameter(hidden)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.functionalConfigurationService.configureActivityComposer(hidden);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/configuration/space")
    public Response updateSpaceConfiguration(SpaceConfiguration space) {
        SpaceConfiguration spaceConfiguration = this.functionalConfigurationService.updateSpaceConfiguration(space);
        return Response.ok((Object)spaceConfiguration, (String)"application/json").build();
    }
}

