/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.rest.response.FunctionalConfiguration;
import org.exoplatform.rest.response.HighlightSpaceConfiguration;
import org.exoplatform.rest.response.SpaceConfiguration;
import org.exoplatform.rest.response.TermsAndConditions;
import org.exoplatform.service.exception.FunctionalConfigurationRuntimeException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.utils.NodeUtils;

public class FunctionalConfigurationService {
    private static final Log LOGGER = ExoLogger.getLogger(FunctionalConfigurationService.class);
    static final String HIDE_DOCUMENT_ACTION_ACTIVITIES = "HIDE_DOCUMENT_ACTION_ACTIVITIES";
    static final String GROUP_SPACES_SETTINGS = "GROUP_SPACES_SETTINGS";
    public static final String HIDE_USER_ACTIVITY_COMPOSER = "hideUserActivityComposer";
    public static final String SPACES_WITHOUT_ACTIVITY_COMPOSER = "spacesWithoutActivityComposer";
    public static final String HIGHLIGHT_SPACES = "highlightspaces";
    static final String TERMS_AND_CONDITIONS_ACTIVE = "TERMS_AND_CONDITIONS_ACTIVE";
    static final String TERMS_AND_CONDITIONS_WEBCONTENT_URL = "TERMS_AND_CONDITIONS_WEBCONTENT_URL";
    public static final String HIGHLIGHT_SPACES_SEPARATOR = "#";
    private static final String SETTINGS_SEPARATOR = ";";
    private SettingService settingService;
    private List<Space> listSpacesWithActivityComposer;
    private List<Space> listSpacesWithoutActivityComposer;
    private SpaceService spaceService;

    public FunctionalConfigurationService(SettingService settingService, SpaceService spaceService) {
        this.settingService = settingService;
        this.spaceService = spaceService;
    }

    public List<Space> getListSpacesWithActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithActivityComposer;
    }

    public List<Space> getListSpacesWithoutActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithoutActivityComposer;
    }

    public String getUserActivityComposerState() {
        SettingValue hideUserActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER);
        return hideUserActivityComposerSetting != null ? (String)hideUserActivityComposerSetting.getValue() : "false";
    }

    public void hideSpaceActivityComposer(String spaces) {
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)(spacesWithoutActivityComposer + (spaces.startsWith(",") ? spaces.substring(0).replace(",", SETTINGS_SEPARATOR) : spaces.replace(",", SETTINGS_SEPARATOR)) + SETTINGS_SEPARATOR)));
    }

    public void showSpaceActivityComposer(String spaces) {
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)spacesWithoutActivityComposer.replace((spaces.startsWith(",") ? spaces.substring(0).replace(",", SETTINGS_SEPARATOR) : spaces.replace(",", SETTINGS_SEPARATOR)) + SETTINGS_SEPARATOR, "")));
    }

    private void initSpaces() throws Exception {
        ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
        Space[] allSpaces = (Space[])allSpacesListAccess.load(0, allSpacesListAccess.getSize());
        String spacesWithoutActivityComposer = this.loadSettingsAsString(SPACES_WITHOUT_ACTIVITY_COMPOSER);
        List<String> spacesWithoutList = Arrays.asList(spacesWithoutActivityComposer.split(SETTINGS_SEPARATOR));
        this.listSpacesWithoutActivityComposer = new ArrayList<Space>();
        this.listSpacesWithActivityComposer = new ArrayList<Space>();
        for (Space space : allSpaces) {
            if (!spacesWithoutActivityComposer.isEmpty() && spacesWithoutList.contains(space.getId())) {
                this.listSpacesWithoutActivityComposer.add(space);
                continue;
            }
            this.listSpacesWithActivityComposer.add(space);
        }
    }

    public List<SpaceConfiguration> findSpaceConfigurations() {
        ArrayList<SpaceConfiguration> spaceConfigurations = new ArrayList<SpaceConfiguration>();
        Map<String, Integer> highlightConfigurationMap = this.loadHighlightConfigAsMap();
        Set<String> activityComposerConfiguration = this.loadActivityComposerConfigurationAsSet();
        Map<String, List<String>> groupSpacesConfigurations = this.loadGroupSpacesSettingAsMap();
        for (Space space : this.findAllSpaces()) {
            SpaceConfiguration spaceConfiguration = new SpaceConfiguration();
            boolean hideActivityComposer = activityComposerConfiguration.stream().anyMatch(f -> space.getId().equals(f));
            String spaceUri = LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
            spaceConfiguration.setSpaceUri(spaceUri);
            spaceConfiguration.setId(space.getId());
            spaceConfiguration.setDisplayName(space.getDisplayName());
            spaceConfiguration.setDescription(space.getDescription());
            spaceConfiguration.setActivityComposerVisible(!hideActivityComposer);
            HighlightSpaceConfiguration highlightConfiguration = new HighlightSpaceConfiguration();
            if (highlightConfigurationMap.containsKey(space.getId())) {
                highlightConfiguration.setHighlight(true);
                highlightConfiguration.setOrder(highlightConfigurationMap.get(space.getId()));
                highlightConfiguration.setGroupIdentifier(this.findGroupIdentifierForSpace(groupSpacesConfigurations, space.getId()));
            } else {
                highlightConfiguration.setHighlight(false);
            }
            spaceConfiguration.setHighlightConfiguration(highlightConfiguration);
            spaceConfigurations.add(spaceConfiguration);
        }
        return spaceConfigurations;
    }

    public String findGroupIdentifierForSpace(Map<String, List<String>> groupSpacesConfigurations, String spaceId) {
        String DEFAULT_GROUP_ID = "0";
        for (Map.Entry<String, List<String>> entry : groupSpacesConfigurations.entrySet()) {
            String groupId = entry.getKey();
            List<String> spacesIds = entry.getValue();
            if (!spacesIds.contains(spaceId)) continue;
            return groupId;
        }
        return "0";
    }

    protected List<Space> findAllSpaces() {
        try {
            ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
            return Arrays.asList(allSpacesListAccess.load(0, allSpacesListAccess.getSize()));
        }
        catch (Exception e) {
            throw new FunctionalConfigurationRuntimeException("space.error.loading");
        }
    }

    public void configureActivityComposer(String hide) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER, SettingValue.create((String)hide));
    }

    public void configureDocumentActionActivities(String hidden) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, HIDE_DOCUMENT_ACTION_ACTIVITIES, SettingValue.create((String)hidden));
    }

    public FunctionalConfiguration getConfiguration() {
        FunctionalConfiguration configuration = new FunctionalConfiguration();
        configuration.setHideComposerActivities(this.isActivityComposerHidden());
        configuration.setHideDocumentActionActivities(this.isDocumentActionActivityHidden());
        configuration.setSpaceConfigurations(this.findSpaceConfigurations());
        configuration.setTermsAndConditions(this.getTermsAndConditions());
        return configuration;
    }

    public TermsAndConditions getTermsAndConditions() {
        TermsAndConditions termsAndConditions = new TermsAndConditions();
        boolean isTermsAndConditionsActive = this.isTermsAndConditionsActive();
        if (isTermsAndConditionsActive) {
            termsAndConditions.setActive(isTermsAndConditionsActive);
            termsAndConditions.setWebContentUrl(this.loadSettingsAsString(TERMS_AND_CONDITIONS_WEBCONTENT_URL));
        }
        return termsAndConditions;
    }

    public boolean isDocumentActionActivityHidden() {
        LOGGER.debug((Object)("Get value for DocumentActionActivityHidden : " + this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_DOCUMENT_ACTION_ACTIVITIES))));
        return this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_DOCUMENT_ACTION_ACTIVITIES));
    }

    private boolean isActivityComposerHidden() {
        return this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER));
    }

    public boolean isTermsAndConditionsActive() {
        return this.getSettingValueAsBoolean(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, TERMS_AND_CONDITIONS_ACTIVE));
    }

    public boolean getSettingValueAsBoolean(SettingValue<?> settingValue) {
        if (Objects.isNull(settingValue) || Objects.isNull(settingValue.getValue()) || StringUtils.isEmpty((CharSequence)settingValue.getValue().toString())) {
            return false;
        }
        return Boolean.parseBoolean(settingValue.getValue().toString());
    }

    public SpaceConfiguration updateSpaceConfiguration(SpaceConfiguration spaceConfiguration) {
        Space space = this.spaceService.getSpaceById(spaceConfiguration.getId());
        if (Objects.isNull(space)) {
            LOGGER.error((Object)("Space with id : " + spaceConfiguration.getId() + " NOT FOUND"));
            throw new FunctionalConfigurationRuntimeException("space.notfound");
        }
        Map<String, Integer> highlightConfigurationsMap = this.loadHighlightConfigAsMap();
        this.updateAndSaveHighlightConfigurationMap(space, spaceConfiguration.getHighlightConfiguration(), highlightConfigurationsMap);
        Set<String> activityComposerConfigurations = this.loadActivityComposerConfigurationAsSet();
        this.updateAndSaveActivityComposerConfigurationSet(spaceConfiguration, space, activityComposerConfigurations);
        HighlightSpaceConfiguration highlightConfiguration = spaceConfiguration.getHighlightConfiguration();
        if (Objects.nonNull(highlightConfiguration) && highlightConfiguration.isHighlight()) {
            this.addSpaceToGroup(space.getId(), highlightConfiguration.getGroupIdentifier());
        }
        return spaceConfiguration;
    }

    void addSpaceToGroup(String spaceId, String groupIdentifier) {
        Map<String, List<String>> groupSpacesConfigurationMap = this.loadGroupSpacesSettingAsMap();
        for (Map.Entry<String, List<String>> entry : groupSpacesConfigurationMap.entrySet()) {
            List<String> spacesIds = entry.getValue();
            spacesIds.remove(spaceId);
        }
        if (Objects.nonNull(groupIdentifier)) {
            if (!groupSpacesConfigurationMap.containsKey(groupIdentifier)) {
                groupSpacesConfigurationMap.put(groupIdentifier, new ArrayList());
            }
            groupSpacesConfigurationMap.get(groupIdentifier).add(spaceId);
        }
        this.saveGroupSpacesSetting(groupSpacesConfigurationMap);
    }

    private void saveGroupSpacesSetting(Map<String, List<String>> groupSpacesConfigurationMap) {
        String groupSpaceSettings = this.convertGroupSpaceSettingMapToStringConfiguration(groupSpacesConfigurationMap);
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, GROUP_SPACES_SETTINGS, SettingValue.create((String)groupSpaceSettings));
    }

    private String convertGroupSpaceSettingMapToStringConfiguration(Map<String, List<String>> groupSpacesConfigurationMap) {
        ArrayList<String> groupSettingsConfiguration = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : groupSpacesConfigurationMap.entrySet()) {
            String groupId = entry.getKey();
            List<String> spacesId = entry.getValue();
            StringJoiner groupSpaceJoiner = new StringJoiner(HIGHLIGHT_SPACES_SEPARATOR);
            groupSpaceJoiner.add(groupId);
            spacesId.forEach(groupSpaceJoiner::add);
            groupSettingsConfiguration.add(groupSpaceJoiner.toString());
        }
        StringJoiner groupJoiner = new StringJoiner(SETTINGS_SEPARATOR);
        groupSettingsConfiguration.forEach(groupJoiner::add);
        return groupJoiner.toString();
    }

    public Map<String, List<String>> loadGroupSpacesSettingAsMap() {
        String[] groupConfigurations;
        boolean GROUP_CONFIGURATION_POSITION = false;
        LinkedHashMap<String, List<String>> groupSpacesConfigurationMap = new LinkedHashMap<String, List<String>>();
        String groupSpacesSettingsValue = this.loadSettingsAsString(GROUP_SPACES_SETTINGS);
        if (StringUtils.isEmpty((CharSequence)groupSpacesSettingsValue)) {
            return groupSpacesConfigurationMap;
        }
        for (String groupConfiguration : groupConfigurations = groupSpacesSettingsValue.split(SETTINGS_SEPARATOR)) {
            String groupId;
            String[] arrayConfiguration = groupConfiguration.split(HIGHLIGHT_SPACES_SEPARATOR);
            if (arrayConfiguration.length == 1) {
                groupId = arrayConfiguration[0];
                groupSpacesConfigurationMap.put(groupId, new ArrayList());
                continue;
            }
            if (arrayConfiguration.length <= 1) continue;
            groupId = arrayConfiguration[0];
            List<String> spacesId = Arrays.asList(arrayConfiguration).subList(1, arrayConfiguration.length);
            groupSpacesConfigurationMap.put(groupId, new ArrayList<String>(spacesId));
        }
        return groupSpacesConfigurationMap;
    }

    private void updateAndSaveActivityComposerConfigurationSet(SpaceConfiguration spaceConfiguration, Space space, Set<String> activityComposerConfigurations) {
        String spaceId = space.getId();
        if (!spaceConfiguration.isActivityComposerVisible()) {
            activityComposerConfigurations.add(spaceId);
        } else {
            activityComposerConfigurations = activityComposerConfigurations.stream().filter(configuration -> !StringUtils.equals((CharSequence)spaceId, (CharSequence)configuration)).collect(Collectors.toSet());
        }
        this.parseAndSaveSettings(SPACES_WITHOUT_ACTIVITY_COMPOSER, new ArrayList<String>(activityComposerConfigurations));
    }

    private void updateAndSaveHighlightConfigurationMap(Space space, HighlightSpaceConfiguration highlightConfiguration, Map<String, Integer> highlightConfigurations) {
        String spaceId = space.getId();
        if (highlightConfiguration.isHighlight()) {
            if (!highlightConfigurations.containsKey(spaceId)) {
                highlightConfigurations.put(spaceId, null);
            }
            highlightConfigurations.put(spaceId, highlightConfiguration.getOrder());
        } else {
            highlightConfigurations.remove(spaceId);
        }
        this.saveHighlightConfiguration(highlightConfigurations);
    }

    private void saveHighlightConfiguration(Map<String, Integer> highlightConfigurationsAsMap) {
        List<String> highlightConfigurationsAsList = highlightConfigurationsAsMap.entrySet().stream().map(entry -> (String)entry.getKey() + HIGHLIGHT_SPACES_SEPARATOR + entry.getValue()).collect(Collectors.toList());
        this.parseAndSaveSettings(HIGHLIGHT_SPACES, highlightConfigurationsAsList);
    }

    private void parseAndSaveSettings(String settingKey, List<String> configurations) {
        String settingsAsString = configurations.stream().collect(Collectors.joining(SETTINGS_SEPARATOR, "", ""));
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, settingKey, SettingValue.create((String)settingsAsString));
    }

    private Set<String> loadActivityComposerConfigurationAsSet() {
        return new HashSet<String>(this.loadAndParseSettings(SPACES_WITHOUT_ACTIVITY_COMPOSER));
    }

    public Map<String, Integer> loadHighlightConfigAsMap() {
        List<String> settings = this.loadAndParseSettings(HIGHLIGHT_SPACES);
        return this.convertHighlightSpacesConfigurationsFromListToMap(settings);
    }

    private Map<String, Integer> convertHighlightSpacesConfigurationsFromListToMap(List<String> highlightSpacesConfigurationsAsList) {
        int HIGHLIGHT_SPACES_CONFIGURATION_LENGTH = 2;
        HashMap<String, Integer> configurationAsMap = new HashMap<String, Integer>();
        for (String configuration : highlightSpacesConfigurationsAsList) {
            String[] split = configuration.split(HIGHLIGHT_SPACES_SEPARATOR);
            if (2 != split.length) continue;
            configurationAsMap.put(split[0], Integer.valueOf(split[1]));
        }
        return configurationAsMap;
    }

    private List<String> loadAndParseSettings(String settingKey) {
        String settingsAsString = this.loadSettingsAsString(settingKey);
        return StringUtils.isNotEmpty((CharSequence)settingsAsString) ? Arrays.asList(settingsAsString.split(SETTINGS_SEPARATOR)) : new ArrayList();
    }

    private String loadSettingsAsString(String settingKey) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, settingKey);
        return Objects.nonNull(settingValue) ? (String)settingValue.getValue() : "";
    }

    public void updateTermsAndConditions(TermsAndConditions termsAndConditions) {
        boolean isActive = termsAndConditions.isActive();
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, TERMS_AND_CONDITIONS_ACTIVE, SettingValue.create((Boolean)isActive));
        if (isActive && Objects.nonNull(NodeUtils.findCollaborationFile(termsAndConditions.getWebContentUrl()))) {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, TERMS_AND_CONDITIONS_WEBCONTENT_URL, SettingValue.create((String)termsAndConditions.getWebContentUrl()));
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, TERMS_AND_CONDITIONS_WEBCONTENT_URL, SettingValue.create((String)""));
        }
    }

    public List<SpaceConfiguration> getSpacesForGroup(String groupIdentifier) {
        List<SpaceConfiguration> spaceConfigurations = this.findSpaceConfigurations();
        Stream<SpaceConfiguration> spaceConfigurationStream = spaceConfigurations.stream().filter(space -> Objects.nonNull(space.getHighlightConfiguration())).filter(space -> space.getHighlightConfiguration().isHighlight());
        if ("0".equals(groupIdentifier)) {
            return spaceConfigurationStream.collect(Collectors.toList());
        }
        return spaceConfigurationStream.filter(space -> groupIdentifier.equals(space.getHighlightConfiguration().getGroupIdentifier())).collect(Collectors.toList());
    }
}

