/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.gamification.github.entity.GitHubHookEntity;
import org.exoplatform.gamification.github.services.GithubHooksManagement;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;

@Path(value="/gamification/connectors/github/hooksmanagement")
public class HooksManagementRest
implements ResourceContainer {
    private static final String PORTAL_CONTAINER_NAME = "portal";
    private static final Log LOG = ExoLogger.getLogger(HooksManagementRest.class);
    private GithubHooksManagement githubHooksManagement;

    public HooksManagementRest(GithubHooksManagement githubHooksManagement) {
        this.githubHooksManagement = githubHooksManagement;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="hooks")
    public Response getHooks(@Context UriInfo uriInfo) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)PORTAL_CONTAINER_NAME);
        if (sourceIdentity == null || this.githubHooksManagement.getSecret() == null || this.githubHooksManagement.getToken() == null || this.githubHooksManagement.getExoEnvironment() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok(this.githubHooksManagement.getAllHooks()).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Path(value="hooks")
    public Response createHook(@Context UriInfo uriInfo, GitHubHookEntity hook) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)PORTAL_CONTAINER_NAME);
        if (sourceIdentity == null || this.githubHooksManagement.getSecret() == null || this.githubHooksManagement.getToken() == null || this.githubHooksManagement.getExoEnvironment() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String baseUri = uriInfo.getBaseUri().toString();
            String serverDomain = baseUri.split(PORTAL_CONTAINER_NAME)[0];
            hook.setWebhook(this.githubHooksManagement.getWebhookUrl());
            String fullPath = serverDomain + this.githubHooksManagement.getWebhookUrl();
            Long id = this.githubHooksManagement.addHook(fullPath, hook.getOrganization(), hook.getRepo(), hook.getEnabled());
            this.githubHooksManagement.createHook(id, hook, true);
            LOG.info("New webhook added by {}", new Object[]{sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Path(value="hooks/{id}")
    public Response editHook(@Context UriInfo uriInfo, @PathParam(value="id") Long id, GitHubHookEntity hook) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)PORTAL_CONTAINER_NAME);
        if (sourceIdentity == null || this.githubHooksManagement.getSecret() == null || this.githubHooksManagement.getToken() == null || this.githubHooksManagement.getExoEnvironment() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String baseUri = uriInfo.getBaseUri().toString();
            String serverDomain = baseUri.split(PORTAL_CONTAINER_NAME)[0];
            hook.setWebhook(this.githubHooksManagement.getWebhookUrl());
            String fullPath = serverDomain + this.githubHooksManagement.getWebhookUrl();
            this.githubHooksManagement.updateHook(hook, fullPath);
            LOG.info("Webhook {} edited by {}", new Object[]{id, sourceIdentity.getRemoteId()});
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Path(value="hooks/{id}")
    public Response deleteHook(@Context UriInfo uriInfo, @PathParam(value="id") Long id) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)PORTAL_CONTAINER_NAME);
        if (sourceIdentity == null || this.githubHooksManagement.getSecret() == null || this.githubHooksManagement.getToken() == null || this.githubHooksManagement.getExoEnvironment() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            GitHubHookEntity hook = this.githubHooksManagement.getHookEntityById(id);
            this.githubHooksManagement.deleteHook(hook);
            LOG.info("Webhook {} deleted by {}", new Object[]{id, sourceIdentity.getRemoteId()});
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"text/plain"})
    @Path(value="users/{id}")
    public Response getUserIdByGithubId(@Context UriInfo uriInfo, @PathParam(value="id") String githubId) {
        String userId = this.githubHooksManagement.getUserByGithubId(githubId);
        if (StringUtils.isNotEmpty((String)userId)) {
            return Response.ok((Object)userId).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

