/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.mapper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;

public class BadgeMapper {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public BadgeDTO badgeToBadgeDTO(BadgeEntity badge) {
        return new BadgeDTO(badge);
    }

    public List<BadgeDTO> badgesToBadgeDTOs(List<BadgeEntity> badges) {
        return badges.stream().filter(Objects::nonNull).map(this::badgeToBadgeDTO).collect(Collectors.toList());
    }

    public BadgeEntity badgeDTOToBadge(BadgeDTO badgeDTO) {
        try {
            if (badgeDTO == null) {
                return null;
            }
            BadgeEntity badge = new BadgeEntity();
            badge.setId(badgeDTO.getId());
            badge.setTitle(badgeDTO.getTitle());
            badge.setDescription(badgeDTO.getDescription());
            badge.setNeededScore(badgeDTO.getNeededScore());
            badge.setDomain(badgeDTO.getDomain());
            badge.setIconFileId(badgeDTO.getIconFileId());
            badge.setStartValidityDate(formatter.parse(badgeDTO.getStartValidityDate()));
            badge.setEndValidityDate(formatter.parse(badgeDTO.getEndValidityDate()));
            badge.setEnabled(badgeDTO.isEnabled());
            badge.setCreatedBy(badgeDTO.getCreatedBy());
            badge.setCreatedDate(formatter.parse(badgeDTO.getCreatedDate()));
            badge.setLastModifiedBy(badgeDTO.getLastModifiedBy());
            badge.setLastModifiedDate(formatter.parse(badgeDTO.getLastModifiedDate()));
            return badge;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<BadgeEntity> badgeDTOsToBadges(List<BadgeDTO> BadgeDTOs) {
        return BadgeDTOs.stream().filter(Objects::nonNull).map(this::badgeDTOToBadge).collect(Collectors.toList());
    }

    public BadgeEntity badgeFromId(Long id) {
        if (id == null) {
            return null;
        }
        BadgeEntity badge = new BadgeEntity();
        badge.setId(id);
        return badge;
    }
}

