/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.effective;

import java.io.Serializable;
import org.exoplatform.addons.gamification.entities.effective.SourceContext;
import org.exoplatform.addons.gamification.entities.effective.TargetContextholder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationContext
implements Serializable {
    private static final Log LOG = ExoLogger.getLogger(GamificationContext.class);
    protected SourceContext sourceContext;
    protected TargetContextholder targetContextholder;

    private GamificationContext() {
    }

    public static GamificationContext instance() {
        return new GamificationContext();
    }

    public GamificationContext clone() {
        return this.clone(false);
    }

    public GamificationContext end() {
        return this;
    }

    public SourceContext getSourceContext() {
        return this.sourceContext;
    }

    public GamificationContext setSourceContext(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
        return this;
    }

    public TargetContextholder getTargetContextholder() {
        return this.targetContextholder;
    }

    public GamificationContext setTargetContextholder(TargetContextholder targetContextholder) {
        this.targetContextholder = targetContextholder;
        return this;
    }

    public GamificationContext clone(boolean isNew) {
        GamificationContext game = GamificationContext.instance();
        game.setSourceContext(this.sourceContext);
        game.setTargetContextholder(this.targetContextholder);
        if (!isNew && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Is not a new Instance");
        }
        return game;
    }

    public String toString() {
        return "GamificationContext{Source:username='" + this.sourceContext.getUsername() + '\'' + ", Source:score='" + this.sourceContext.getScore() + '\'' + ", Source:createdDate='" + this.sourceContext.getCreatedDate() + '\'' + ", Source:lastModifiedDate='" + this.sourceContext.getLastModifiedDate() + '\'' + ", Target:usernames='" + this.targetContextholder.getUsernames() + '\'' + ", Target:score ='" + this.targetContextholder.getScore() + '\'' + "}";
    }
}

