/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.jgroups.util.DefaultThreadFactory;

public class GamificationUtils {
    public static String BLACK_LISTED_USERS_GROUP = "/leaderboard-blacklist-users";
    public static final String GAMIFICATION_DATAMODEL_MIGRATION_USER_KEY = "GAMIFICATION_DATAMODEL_MIGRATION_USER";
    public static final String GAMIFICATION_DATAMODEL_MIGRATION_DONE_KEY = "GAMIFICATION_DATAMODEL_MIGRATION_DONE_KEY";
    public static final String GAMIFICATION_DATAMODEL_MIGRATION_DONE = "GAMIFICATION_DATAMODEL_MIGRATION_DONE";
    private static ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("GAMIFICATION-DATAMODEL-MIGRATION", false, false));

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static boolean isGamificationDatamodelMigrated() {
        SettingValue setting = ((SettingService)CommonsUtils.getService(SettingService.class)).get(Context.GLOBAL, Scope.APPLICATION.id(GAMIFICATION_DATAMODEL_MIGRATION_DONE_KEY), GAMIFICATION_DATAMODEL_MIGRATION_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    public static void setGamificationDatamodelMigrationDone() {
        ((SettingService)CommonsUtils.getService(SettingService.class)).set(Context.GLOBAL, Scope.APPLICATION.id(GAMIFICATION_DATAMODEL_MIGRATION_DONE_KEY), GAMIFICATION_DATAMODEL_MIGRATION_DONE, SettingValue.create((String)"true"));
    }

    public static boolean isGamificationDatamodelMigrated(String userName) {
        SettingValue setting = ((SettingService)CommonsUtils.getService(SettingService.class)).get(Context.USER.id(userName), Scope.APPLICATION.id(GAMIFICATION_DATAMODEL_MIGRATION_USER_KEY), GAMIFICATION_DATAMODEL_MIGRATION_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    public static boolean isBlackListed(String userName) {
        ArrayList<String> blackListedUsers = new ArrayList<String>();
        try {
            ListAccess usersBlackList = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().findUsersByGroupId(BLACK_LISTED_USERS_GROUP);
            if (null != usersBlackList && usersBlackList.getSize() > 0) {
                User[] managerUser;
                for (User user : managerUser = (User[])usersBlackList.load(0, usersBlackList.getSize())) {
                    try {
                        blackListedUsers.add(user.getUserName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return blackListedUsers.stream().anyMatch(userName::equals);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String extractProfileOwnerFromUrl(String url, String separator) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        if (StringUtils.isEmpty((CharSequence)separator)) {
            return "";
        }
        int pos = url.lastIndexOf(separator);
        if (pos == -1 || pos == url.length() - separator.length()) {
            return "";
        }
        return url.substring(pos + separator.length());
    }

    public static Space extractSpaceNameFromUrl(String url) throws Exception {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String spaceName = url.split(":spaces:")[1].split("/")[0];
        sb.append("/spaces/").append(spaceName);
        Space space = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceByGroupId(sb.toString());
        return space;
    }
}

