/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.util.List;
import java.util.concurrent.Callable;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.completation.GamificationCompletionService;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationProcessor {
    private static final Log LOG = ExoLogger.getLogger(GamificationProcessor.class);
    protected final GamificationCompletionService gamificationCompletionService = (GamificationCompletionService)CommonsUtils.getService(GamificationCompletionService.class);
    protected final GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public boolean process(final List<GamificationContextHolder> gamificationContexts) {
        try {
            Callable<Boolean> task = new Callable<Boolean>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean call() throws Exception {
                    try {
                        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                        if (gamificationContexts != null && gamificationContexts.isEmpty()) return true;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Process GamificationUserReputation is failed: " + e.getMessage()), (Throwable)e);
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                    return true;
                }
            };
            this.gamificationCompletionService.addTask(task);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"Error processing gamification action", (Throwable)e);
            return false;
        }
    }

    public void execute(GamificationActionsHistory actionsHistory) throws Exception {
        try {
            if (actionsHistory != null) {
                this.gamificationService.saveActionHistory(actionsHistory);
            }
        }
        catch (Exception e) {
            LOG.error("Error to save an actionHistory entry {}", new Object[]{actionsHistory, e});
        }
    }
}

