/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.space;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationSpaceListener
extends SpaceListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationSpaceListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void spaceCreated(SpaceLifeCycleEvent event) {
        GamificationActionsHistory aHistory = null;
        String actorUsername = (String)event.getSource();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("addSpace");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
        GamificationActionsHistory aHistory = null;
        String actorUsername = (String)event.getSource();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("joinSpace");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        GamificationActionsHistory aHistory = null;
        String actorUsername = (String)event.getSource();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("grantUserAsLead");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }
}

