/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.task;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;

public class GamificationTaskCommentListener
extends Listener<TaskService, Comment>
implements GamificationListener {
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationTaskCommentListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<TaskService, Comment> event) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        GamificationActionsHistory aHistory = null;
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("commentTask");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId, actorId, TaskUtil.buildTaskURL((Task)((Comment)event.getData()).getTask()));
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
            }
        }
    }
}

