/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/rules")
@Produces(value={"application/json"})
@RolesAllowed(value={"administrators"})
public class ManageRulesEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageRulesEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected RuleService ruleService = null;
    protected IdentityManager identityManager = null;

    public ManageRulesEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    }

    @GET
    @Path(value="/all")
    public Response getAllRules(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                List<RuleDTO> allRules = this.ruleService.getAllRules();
                return Response.ok().cacheControl(this.cacheControl).entity(allRules).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error listing all rules ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error listing all rules").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/add")
    public Response addRule(@Context SecurityContext securityContext, @Context UriInfo uriInfo, RuleDTO ruleDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                ruleDTO.setId(null);
                ruleDTO.setCreatedBy(currentUserName);
                ruleDTO.setLastModifiedBy(currentUserName);
                ruleDTO.setLastModifiedDate(new Date());
                ruleDTO = this.ruleService.addRule(ruleDTO);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error adding new rule {} by {} ", new Object[]{ruleDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error adding new rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @PUT
    @Path(value="/update")
    public Response updateRule(@Context UriInfo uriInfo, @Context HttpServletRequest request, RuleDTO ruleDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                Locale lc = request.getLocale();
                ruleDTO.setCreatedBy(currentUserName);
                ruleDTO.setLastModifiedBy(currentUserName);
                ruleDTO.setLastModifiedDate(new Date());
                ruleDTO = this.ruleService.updateRule(ruleDTO);
                String actorId = this.identityManager.getOrCreateIdentity("organization", currentUserName, false).getId();
                LOG.info("service=gamification operation=edit-rule parameters=\"user_social_id:{},rule_id:{},rule_title:{},rule_description:{}\"", new Object[]{actorId, ruleDTO.getId(), ruleDTO.getTitle(), ruleDTO.getDescription()});
                return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error updating rule {} by {} ", new Object[]{ruleDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error updating a rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @DELETE
    @Path(value="/delete")
    public Response deleteRule(@Context UriInfo uriInfo, @QueryParam(value="ruleTitle") String ruleTitle) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                this.ruleService.deleteRule(ruleTitle);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)("Rule " + ruleTitle + " has been removed successfully ")).build();
            }
            catch (Exception e) {
                LOG.error("Error deleting rule {} by {} ", new Object[]{ruleTitle, currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error deleting a rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

