/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.profile;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public class GamificationProfileListener
extends ProfileListenerPlugin {
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected GamificationService gamificationService;
    protected AnnouncementService announcementService;
    private ActivityStorage activityStorage;

    public GamificationProfileListener(RuleService ruleService, IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService, AnnouncementService announcementService, ActivityStorage activityStorage) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.gamificationService = gamificationService;
        this.announcementService = announcementService;
        this.activityStorage = activityStorage;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        Long lastUpdate = event.getProfile().getAvatarLastUpdated();
        String identityId = event.getProfile().getIdentity().getId();
        if (lastUpdate != null) {
            return;
        }
        this.gamificationService.createHistory("addUserProfileAvatar", identityId, identityId, event.getProfile().getUrl());
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        Long lastUpdate = event.getProfile().getBannerLastUpdated();
        String identityId = event.getProfile().getIdentity().getId();
        if (lastUpdate != null) {
            return;
        }
        this.gamificationService.createHistory("addUserProfileBanner", identityId, identityId, event.getProfile().getUrl());
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        String userId = event.getProfile().getIdentity().getId();
        this.clearUserActivitiesCache(userId);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        String identityId = event.getProfile().getIdentity().getId();
        this.gamificationService.createHistory("addUserProfileAboutMe", identityId, identityId, event.getProfile().getUrl());
    }

    private void clearUserActivitiesCache(String userId) {
        List<Announcement> announcements = this.announcementService.getAnnouncementsByEarnerId(userId);
        if (CollectionUtils.isEmpty(announcements)) {
            return;
        }
        announcements.forEach(announcement -> ((CachedActivityStorage)this.activityStorage).clearActivityCached(String.valueOf(announcement.getActivityId())));
    }
}

