/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.storage.ProgramStorage;
import java.util.List;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.upload.UploadService;

public class ProgramCachedStorage
extends ProgramStorage {
    private static final String PROGRAM_CACHE_NAME = "gamification.domain";
    private FutureExoCache<Long, ProgramDTO, Object> programFutureCache;
    private List<String> administrators;

    public ProgramCachedStorage(FileService fileService, UploadService uploadService, ProgramDAO programDAO, RuleDAO ruleDAO, CacheService cacheService, ListenerService listenerService, OrganizationService organizationService) {
        super(fileService, uploadService, programDAO, ruleDAO, organizationService);
        ExoCache programCache = cacheService.getCacheInstance(PROGRAM_CACHE_NAME);
        Loader<Long, ProgramDTO, Object> programLoader = new Loader<Long, ProgramDTO, Object>(){

            public ProgramDTO retrieve(Object context, Long id) throws Exception {
                return ProgramCachedStorage.super.getProgramById(id);
            }
        };
        this.programFutureCache = new FutureExoCache((Loader)programLoader, programCache);
        listenerService.addListener("rule.created", (Listener)new RuleUpdatedListener());
        listenerService.addListener("rule.deleted", (Listener)new RuleUpdatedListener());
        listenerService.addListener("rule.updated", (Listener)new RuleUpdatedListener());
        organizationService.getMembershipHandler().addMembershipEventListener((MembershipEventListener)new RewardingAdministratorMembershipListener());
    }

    @Override
    public ProgramDTO saveProgram(ProgramDTO program) {
        try {
            ProgramDTO programDTO = program = super.saveProgram(program);
            return programDTO;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public void updateProgramDate(long programId) {
        try {
            super.updateProgramDate(programId);
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public ProgramDTO getProgramById(Long id) {
        ProgramDTO program = (ProgramDTO)this.programFutureCache.get(null, (Object)id);
        return program == null ? null : program.clone();
    }

    @Override
    public void deleteImage(long fileId) {
        try {
            super.deleteImage(fileId);
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public List<String> getAdministrators() {
        if (this.administrators == null) {
            this.administrators = super.getAdministrators();
        }
        return this.administrators;
    }

    @Override
    public void clearCache() {
        this.programFutureCache.clear();
    }

    public class RuleUpdatedListener
    extends Listener<Object, String> {
        public void onEvent(Event<Object, String> event) throws Exception {
            ProgramCachedStorage.this.clearCache();
        }
    }

    public class RewardingAdministratorMembershipListener
    extends MembershipEventListener {
        public void postSave(Membership m, boolean isNew) throws Exception {
            this.clearCachedAdministrators(m);
        }

        public void postDelete(Membership m) throws Exception {
            this.clearCachedAdministrators(m);
        }

        private void clearCachedAdministrators(Membership m) {
            if (m != null && "/platform/rewarding".equals(m.getGroupId())) {
                ProgramCachedStorage.this.administrators = null;
            }
        }
    }
}

