/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.storage.EventStorage;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class EventServiceImpl
implements EventService {
    private final EventStorage eventStorage;

    public EventServiceImpl(EventStorage eventStorage) {
        this.eventStorage = eventStorage;
    }

    @Override
    public List<EventDTO> getEvents(EventFilter eventFilter, int offset, int limit) {
        return this.eventStorage.findEventsByFilter(eventFilter, offset, limit);
    }

    @Override
    public List<EventDTO> getEventsByTitle(String title, int offset, int limit) {
        return this.eventStorage.getEventsByTitle(title, offset, limit);
    }

    @Override
    public int countEvents(EventFilter eventFilter) {
        return this.eventStorage.countEventsByFilter(eventFilter);
    }

    @Override
    public EventDTO getEventByTitleAndTrigger(String title, String trigger) {
        return this.eventStorage.getEventByTitleAndTrigger(title, trigger);
    }

    @Override
    public EventDTO getEventByTypeAndTitle(String type, String title) {
        return this.eventStorage.getEventByTypeAndTitle(type, title);
    }

    @Override
    public EventDTO createEvent(EventDTO eventDTO) throws ObjectAlreadyExistsException {
        if (eventDTO == null) {
            throw new IllegalArgumentException("event object is mandatory");
        }
        EventDTO similarEvent = this.eventStorage.getEventByTitleAndTrigger(eventDTO.getTitle(), eventDTO.getTrigger());
        if (similarEvent != null) {
            throw new ObjectAlreadyExistsException((Object)"Event with same title and trigger already exist");
        }
        return this.eventStorage.saveEvent(eventDTO);
    }

    @Override
    public EventDTO updateEvent(EventDTO eventDTO) throws ObjectNotFoundException {
        if (eventDTO.getId() <= 0L) {
            throw new IllegalArgumentException("Event id must not be null");
        }
        EventDTO storedEvent = this.eventStorage.getEventById(eventDTO.getId());
        if (storedEvent == null) {
            throw new ObjectNotFoundException("Event with id " + eventDTO.getId() + " is not found");
        }
        return this.eventStorage.saveEvent(eventDTO);
    }

    @Override
    public EventDTO getEvent(long eventId) {
        return this.eventStorage.getEventById(eventId);
    }

    @Override
    public EventDTO deleteEventById(long eventId) throws ObjectNotFoundException {
        EventDTO eventDTO;
        try {
            eventDTO = this.eventStorage.deleteEventById(eventId);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Event with id " + eventId + " is not found");
        }
        return eventDTO;
    }
}

