/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.dao.EventDAO;
import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.storage.mapper.EventMapper;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class EventStorage {
    private final EventDAO eventDAO;

    public EventStorage(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public List<EventDTO> findEventsByFilter(EventFilter eventFilter, int offset, int limit) {
        return EventMapper.fromEntities(this.eventDAO.findEventsByFilter(eventFilter, offset, limit));
    }

    public int countEventsByFilter(EventFilter eventFilter) {
        return this.eventDAO.countEventByFilter(eventFilter);
    }

    public EventDTO getEventByTitleAndTrigger(String title, String trigger) {
        return EventMapper.fromEntity(this.eventDAO.getEventByTitleAndTrigger(title, trigger));
    }

    public EventDTO getEventByTypeAndTitle(String type, String title) {
        return EventMapper.fromEntity(this.eventDAO.getEventByTypeAndTitle(type, title));
    }

    public List<EventDTO> getEventsByTitle(String title, int offset, int limit) {
        return EventMapper.fromEntities(this.eventDAO.getEventsByTitle(title, offset, limit));
    }

    public EventDTO saveEvent(EventDTO eventDTO) {
        EventEntity eventEntity = EventMapper.toEntity(eventDTO);
        eventEntity = eventEntity.getId() == null ? (EventEntity)this.eventDAO.create(eventEntity) : (EventEntity)this.eventDAO.update(eventEntity);
        return EventMapper.fromEntity(eventEntity);
    }

    public EventDTO getEventById(long eventId) {
        return EventMapper.fromEntity((EventEntity)this.eventDAO.find(Long.valueOf(eventId)));
    }

    public EventDTO deleteEventById(long eventId) throws ObjectNotFoundException {
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " does not exist");
        }
        this.eventDAO.delete(eventEntity);
        return EventMapper.fromEntity(eventEntity);
    }
}

