/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.activity;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationActivityListener
extends ActivityListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
    protected ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (!(activity.getType().equalsIgnoreCase("DOC_ACTIVITY") || activity.getType().equalsIgnoreCase("UIDocActivityComposer") || activity.getType().equalsIgnoreCase("share_document") || (ruleDto = this.ruleService.findEnableRuleByTitle("uploaddocumentOnNetworkStream")) == null)) {
            try {
                aHistory = this.build(ruleDto, activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if (this.isSpaceActivity(activity) && !activity.getType().equals("SPACE_ACTIVITY")) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStreamTarget")) != null) {
                try {
                    String spaceManager = this.spaceService.getSpaceByPrettyName(this.identityManager.getIdentity(activity.getStreamId()).getRemoteId()).getManagers()[0];
                    aHistory = this.build(ruleDto, activity.getPosterId(), this.identityManager.getOrCreateIdentity("organization", spaceManager, false).getId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId()) && !activity.getType().equals("SPACE_ACTIVITY")) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnMyStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getStreamId(), activity.getStreamId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (!activity.getType().equals("SPACE_ACTIVITY")) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnNetworkStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityTargetUserStream")) != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getStreamId(), activity.getStreamId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
            return;
        }
        if (parent != null && !parent.getType().equals("SPACE_ACTIVITY")) {
            ruleDto = this.ruleService.findEnableRuleByTitle("commentOnNetworkStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), parent.getPosterId(), "/portal/intranet/activity?id=" + parent.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addComment")) != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + parent.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            String liker;
            String[] likersId;
            ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    likersId = activity.getLikeIdentityIds();
                    liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
                    aHistory = this.build(ruleDto, activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStreamTarget");
            likersId = activity.getLikeIdentityIds();
            liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            if (activity.getPosterId().equalsIgnoreCase(liker)) {
                return;
            }
            ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnNetworkStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityTargetUserStream")) != null) {
                try {
                    aHistory = this.build(ruleDto, liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String[] likersId = activity.getLikeIdentityIds();
        String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnspaceStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
                return;
            }
            String commentOwner = activity.getPosterId();
            ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnNetworkStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
        if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeComment")) != null) {
            try {
                aHistory = this.build(ruleDto, liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = this.identityManager.getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }
}

