/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.rule.model;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class RuleConfig
extends BaseComponentPlugin {
    private String title;
    private String description;
    private int score;
    private String zone;
    private boolean enable;

    public RuleConfig(InitParams params) throws Exception {
        ValueParam enableParam;
        ValueParam zoneParam;
        ValueParam scoreParam;
        ValueParam titleParam = params.getValueParam("rule-title");
        if (titleParam == null) {
            throw new ConfigurationException("No 'rule-title' parameter found");
        }
        this.title = titleParam.getValue();
        ValueParam descriptionParam = params.getValueParam("rule-description");
        if (descriptionParam != null) {
            this.description = descriptionParam.getValue();
        }
        if ((scoreParam = params.getValueParam("rule-score")) != null) {
            this.score = Integer.parseInt(scoreParam.getValue());
        }
        if ((zoneParam = params.getValueParam("rule-zone")) != null) {
            this.zone = zoneParam.getValue();
        }
        if ((enableParam = params.getValueParam("rule-enable")) != null) {
            this.enable = Boolean.parseBoolean(enableParam.getValue());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getScore() {
        return this.score;
    }

    public String getZone() {
        return this.zone;
    }

    public boolean isEnable() {
        return this.enable;
    }
}

