/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.DomainStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DomainServiceImpl
implements DomainService {
    private static final Log LOG = ExoLogger.getLogger(DomainServiceImpl.class);
    protected final DomainStorage domainStorage = (DomainStorage)CommonsUtils.getService(DomainStorage.class);
    protected final ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
    public static final String GAMIFICATION_DOMAIN_LISTENER = "exo.gamification.domain.action";

    @Override
    public List<DomainDTO> getAllDomains() {
        try {
            return this.domainStorage.getAllDomains();
        }
        catch (Exception e) {
            LOG.error((Object)"Error to find Domains", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<DomainDTO> getEnabledDomains() {
        try {
            return this.domainStorage.getEnabledDomains();
        }
        catch (Exception e) {
            LOG.error((Object)"Error to find Domains", (Throwable)e);
            throw e;
        }
    }

    @Override
    public DomainDTO findDomainByTitle(String domainTitle) {
        try {
            return this.domainStorage.findDomainByTitle(domainTitle);
        }
        catch (Exception e) {
            LOG.error("Error to find Domain entity with title : {}", new Object[]{domainTitle, e});
            throw e;
        }
    }

    @Override
    public DomainDTO addDomain(DomainDTO domainDTO) {
        DomainDTO oldDomainDTO = null;
        String date = Utils.toRFC3339Date(new Date(System.currentTimeMillis()));
        try {
            oldDomainDTO = this.domainStorage.findDomainByTitle(domainDTO.getTitle());
            if (oldDomainDTO == null) {
                domainDTO.setCreatedDate(date);
                domainDTO.setLastModifiedDate(date);
                domainDTO = this.domainStorage.saveDomain(domainDTO);
            } else if (oldDomainDTO.isDeleted()) {
                domainDTO.setId(oldDomainDTO.getId());
                domainDTO.setLastModifiedDate(date);
                domainDTO = this.domainStorage.saveDomain(domainDTO);
            }
        }
        catch (Exception e) {
            LOG.error("Error to create domain with title {}", new Object[]{domainDTO.getTitle(), e});
            throw e;
        }
        return domainDTO;
    }

    @Override
    public DomainDTO updateDomain(DomainDTO domainDTO) throws ObjectNotFoundException {
        String date = Utils.toRFC3339Date(new Date(System.currentTimeMillis()));
        DomainDTO oldDomainDTO = this.domainStorage.getDomainByID(domainDTO.getId());
        if (oldDomainDTO != null) {
            domainDTO.setLastModifiedDate(date);
            domainDTO = this.domainStorage.saveDomain(domainDTO);
            DomainEntity domainEntity = DomainMapper.domainDTOToDomain(domainDTO);
            try {
                if (oldDomainDTO.isEnabled() && !domainDTO.isEnabled()) {
                    this.listenerService.broadcast(GAMIFICATION_DOMAIN_LISTENER, (Object)domainEntity, (Object)"disable");
                }
                if (!oldDomainDTO.isEnabled() && domainDTO.isEnabled()) {
                    this.listenerService.broadcast(GAMIFICATION_DOMAIN_LISTENER, (Object)domainEntity, (Object)"enable");
                }
            }
            catch (Exception e) {
                LOG.error("Error to update domain {} with title {}", new Object[]{domainDTO.getId(), domainDTO.getTitle(), e});
            }
            return domainDTO;
        }
        throw new ObjectNotFoundException("domain is not exist");
    }

    @Override
    public void deleteDomain(Long id) throws EntityNotFoundException {
        String date = Utils.toRFC3339Date(new Date(System.currentTimeMillis()));
        DomainDTO domainDTO = this.domainStorage.getDomainByID(id);
        if (domainDTO != null) {
            domainDTO.setDeleted(true);
            domainDTO.setLastModifiedDate(date);
            domainDTO = this.domainStorage.saveDomain(domainDTO);
            try {
                DomainEntity domainEntity = DomainMapper.domainDTOToDomain(domainDTO);
                this.listenerService.broadcast(GAMIFICATION_DOMAIN_LISTENER, (Object)domainEntity, (Object)"delete");
            }
            catch (Exception e) {
                LOG.error("Error to delete domain {}", new Object[]{id, e});
            }
        } else {
            LOG.warn("Domain {} not Found", new Object[]{id});
            throw new EntityNotFoundException();
        }
    }
}

