/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.ChallengeRestEntity;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/gamification/challenge/api")
@Api(value="/challenge/api", description="Manages challenge associated to users")
@RolesAllowed(value={"users"})
public class ChallengeRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ChallengeRest.class);
    private ChallengeService challengeService;
    private AnnouncementService announcementService;

    public ChallengeRest(ChallengeService challengeService, AnnouncementService announcementService) {
        this.challengeService = challengeService;
        this.announcementService = announcementService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="addChallenge")
    @ApiOperation(value="Creates a new challenge", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createChallenge(@ApiParam(value="Challenge object to create", required=true) Challenge challenge) {
        if (challenge == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge object is mandatory").build();
        }
        String currentUser = Utils.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            LOG.warn((Object)"current User is null");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Challenge newChallenge = this.challengeService.createChallenge(challenge, currentUser);
            return Response.ok((Object)EntityMapper.fromChallenge(newChallenge, Collections.emptyList())).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)"User '{}' attempts to create a challenge", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a challenge", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{challengeId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves a challenge by its id", httpMethod="GET", response=Response.class, produces="application/json", notes="returns selected challenge if exists")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getChallengeById(@ApiParam(value="Challenge technical id", required=true) @PathParam(value="challengeId") long challengeId, @ApiParam(value="Offset of result", required=false) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of result", required=false) @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (challengeId == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty challengeId");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUser();
        try {
            Challenge challenge = this.challengeService.getChallengeById(challengeId, currentUserId);
            if (challenge == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List<Announcement> announcementList = this.announcementService.findAllAnnouncementByChallenge(challengeId, offset, limit);
            return Response.ok((Object)EntityMapper.fromChallenge(challenge, announcementList)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting challenge", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="updateChallenge")
    @ApiOperation(value="Updates an existing challenge", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateChallenge(@ApiParam(value="challenge object to update", required=true) Challenge challenge, @ApiParam(value="Offset of result", required=false) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of result", required=false) @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (challenge == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge object is mandatory").build();
        }
        if (challenge.getId() <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge technical identifier must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            challenge = this.challengeService.updateChallenge(challenge, currentUser);
            List<Announcement> announcementList = this.announcementService.findAllAnnouncementByChallenge(challenge.getId(), offset, limit);
            return Response.ok((Object)EntityMapper.fromChallenge(challenge, announcementList)).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing challenge '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Challenge not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a challenge for owner '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a challenge", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="allChallenge")
    @ApiOperation(value="Retrieves the list of challenges available for an owner", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllChallengesByUser(@ApiParam(value="Offset of result", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of result", required=false, defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="number of announcement per challenge", required=false, defaultValue="2") @QueryParam(value="announcements") int announcements) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            LOG.info((Object)"start getting challenges");
            List<Challenge> challenges = this.challengeService.getAllChallengesByUser(offset, limit, currentUser);
            ArrayList<ChallengeRestEntity> challengeRestEntities = new ArrayList<ChallengeRestEntity>();
            LOG.info((Object)"start mapping challenges");
            for (Challenge challenge : challenges) {
                List<Announcement> challengeAnnouncements = this.announcementService.findAllAnnouncementByChallenge(challenge.getId(), 0, announcements);
                challengeRestEntities.add(EntityMapper.fromChallenge(challenge, challengeAnnouncements));
            }
            LOG.info((Object)"ended mapping challenges");
            return Response.ok(challengeRestEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized challenges with owner Ids", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of challenges", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="canAddChallenge")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can add a challenge", httpMethod="GET", response=Response.class, notes="This checks if the current user user can add a challenge", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="User ability to add a challenge is returned"), @ApiResponse(code=401, message="User not authorized to add a challenge")})
    public Response canAddChallenge() {
        try {
            return Response.ok((Object)String.valueOf(this.challengeService.canAddChallenge())).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can add a challenge", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/delete/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can add a challenge", httpMethod="GET", response=Response.class, notes="This checks if the current user user can add a challenge", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="challenge deleted"), @ApiResponse(code=401, message="User not authorized to delete a challenge"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteChallenge(@ApiParam(value="challenge id to be deleted", required=true) @PathParam(value="id") Long challengeId) {
        if (challengeId == null || challengeId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge technical identifier must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            this.challengeService.deleteChallenge(challengeId, currentUser);
            return Response.ok().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error((Object)"challenge trying to delete not found", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"challenge trying to delete not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("unauthorized user {} trying to delete a challenge", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"unauthorized user trying to delete a challenge").build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when deleting challenge", (Throwable)e);
            return Response.serverError().entity((Object)"Error when deleting challenge").build();
        }
    }
}

