/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class DomainDAO
extends GenericDAOJPAImpl<DomainEntity, Long>
implements GenericDAO<DomainEntity, Long> {
    private static final String QUERY_FILTER_FIND_PREFIX = "GamificationDomain.findAllDomains";
    private static final String QUERY_FILTER_COUNT_PREFIX = "GamificationDomain.countAllDomains";
    public static final String DOMAIN_TITLE = "domainTitle";
    private final Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();

    public DomainEntity findByIdWithOwners(Long id) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.findByIdWithOwners", DomainEntity.class);
        query.setParameter("id", (Object)id);
        try {
            return (DomainEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public DomainEntity findEnabledDomainByTitle(String domainTitle) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.findEnabledDomainByTitle", DomainEntity.class);
        query.setParameter(DOMAIN_TITLE, (Object)domainTitle);
        List domainEntities = query.getResultList();
        return !domainEntities.isEmpty() ? (DomainEntity)domainEntities.get(0) : null;
    }

    public DomainEntity getDomainByTitle(String domainTitle) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.findDomainByTitle", DomainEntity.class);
        query.setParameter(DOMAIN_TITLE, (Object)domainTitle);
        List domainEntities = query.getResultList();
        return !domainEntities.isEmpty() ? (DomainEntity)domainEntities.get(0) : null;
    }

    public List<Long> getDomainsByFilter(int offset, int limit, DomainFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public int countAllDomains(DomainFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<DomainEntity> getEnabledDomains() {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.getEnabledDomains", DomainEntity.class);
        return query.getResultList();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(DomainFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private <T> void addQueryFilterParameters(DomainFilter filter, TypedQuery<T> query) {
        EntityFilterType entityFilterType;
        if (CollectionUtils.isNotEmpty(filter.getSpacesIds())) {
            query.setParameter("spacesIds", filter.getSpacesIds());
        }
        if ((entityFilterType = filter.getEntityFilterType()) != null && entityFilterType != EntityFilterType.ALL) {
            query.setParameter("type", (Object)EntityType.valueOf(entityFilterType.name()));
        }
        if (StringUtils.isNotEmpty((String)filter.getDomainTitle())) {
            query.setParameter("searchingKey", (Object)("%" + filter.getDomainTitle() + "%"));
        }
    }

    private void buildPredicates(DomainFilter filter, List<String> suffixes, List<String> predicates) {
        EntityStatusType entityStatusType;
        if (CollectionUtils.isNotEmpty(filter.getSpacesIds())) {
            suffixes.add("Audience");
            predicates.add("(d.audienceId in (:spacesIds) OR d.audienceId IS NULL)");
        }
        if (filter.getEntityFilterType() != null && filter.getEntityFilterType() != EntityFilterType.ALL) {
            suffixes.add("Type");
            predicates.add("d.type = :type");
        }
        if (StringUtils.isNotEmpty((String)filter.getDomainTitle())) {
            suffixes.add("SearchBy");
            predicates.add(" UPPER(d.title) like UPPER(:searchingKey) ");
        }
        if (!filter.isIncludeDeleted()) {
            suffixes.add("ExcludeDeleted");
            predicates.add("d.isDeleted = false");
        }
        if ((entityStatusType = filter.getEntityStatusType()) != null && entityStatusType != EntityStatusType.ALL) {
            switch (entityStatusType) {
                case ENABLED: {
                    suffixes.add("EnabledStatus");
                    predicates.add("d.isEnabled = true");
                    break;
                }
                case DISABLED: {
                    suffixes.add("DisabledStatus");
                    predicates.add("d.isEnabled = false");
                    break;
                }
            }
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private String getQueryFilterContent(List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(d) FROM GamificationDomain d " : "SELECT d.id FROM GamificationDomain d ";
        String orderBy = " ORDER BY d.createdDate DESC";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + orderBy;
        }
        return queryContent;
    }
}

