/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.rest.model.GamificationActionsHistoryRestEntity;
import org.exoplatform.addons.gamification.rest.model.RealizationList;
import org.exoplatform.addons.gamification.service.RealizationsService;
import org.exoplatform.addons.gamification.service.dto.configuration.GamificationActionsHistoryDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RealizationsFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.mapper.GamificationActionsHistoryMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/realizations/api")
@Tag(name="/gamification/realizations/api", description="Manages users realizations")
@RolesAllowed(value={"administrators"})
public class RealizationsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RealizationsRest.class);
    private RealizationsService realizationsService;
    private IdentityManager identityManager;

    public RealizationsRest(RealizationsService realizationsService, IdentityManager identityManager) {
        this.realizationsService = realizationsService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json", "application/vnd.ms-excel"})
    @Path(value="allRealizations")
    @Operation(summary="Retrieves the list of achievements switch a filter. The returned format can be of type JSON or XLSX", method="GET", description="Retrieves the list of challenges available for an owner")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    @RolesAllowed(value={"users"})
    public Response getAllRealizations(@Context HttpServletRequest httpRequest, @Parameter(description="result fromDate", required=true) @QueryParam(value="fromDate") String fromDate, @Parameter(description="result toDate", required=true) @QueryParam(value="toDate") String toDate, @Parameter(description="Sort field. Possible values: date or actionType.") @QueryParam(value="sortBy") @DefaultValue(value="date") String sortField, @Parameter(description="Whether to retrieve results sorted descending or not") @QueryParam(value="sortDescending") @DefaultValue(value="true") boolean sortDescending, @Parameter(description="earnerIds, that will be used to filter achievements", required=false) @QueryParam(value="earnerIds") List<String> earnerIds, @Parameter(description="Offset of result") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of result") @QueryParam(value="limit") int limit, @Parameter(description="Response Type") @DefaultValue(value="") @QueryParam(value="returnType") String returnType, @Parameter(description="identity Type") @QueryParam(value="identityType") String identityType, @Parameter(description="domainIds. that will be used to filter achievements", required=false) @QueryParam(value="domainIds") List<Long> domainIds, @Parameter(description="If true, this will return the total count of filtered realizations. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize) {
        boolean isXlsx;
        if (StringUtils.isBlank((CharSequence)fromDate) || StringUtils.isBlank((CharSequence)toDate)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Dates must not be blank").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        Date dateFrom = Utils.parseRFC3339Date(fromDate);
        Date dateTo = Utils.parseRFC3339Date(toDate);
        if (domainIds == null) {
            domainIds = new ArrayList<Long>();
        }
        RealizationsFilter filter = new RealizationsFilter(earnerIds, sortField, sortDescending, dateFrom, dateTo, IdentityType.getType(identityType), domainIds);
        boolean bl = isXlsx = StringUtils.isNotBlank((CharSequence)returnType) && returnType.equals("xlsx");
        if (StringUtils.isNotBlank((CharSequence)returnType) && !returnType.equals("json") && !isXlsx) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unsupported returnType, possible values: xlsx or json").build();
        }
        if (!isXlsx && limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        try {
            if (isXlsx) {
                String filename = "report_Actions";
                InputStream xlsxInputStream = this.realizationsService.exportXlsx(filter, identity, filename, httpRequest.getLocale());
                return Response.ok((Object)xlsxInputStream).header("Content-Disposition", (Object)("attachment; filename=" + filename + ".xlsx")).header("Content-Type", (Object)"application/vnd.ms-excel").build();
            }
            List<GamificationActionsHistoryDTO> gActionsHistoryList = this.realizationsService.getRealizationsByFilter(filter, identity, offset, limit);
            List<GamificationActionsHistoryRestEntity> gamificationActionsHistoryRestEntities = GamificationActionsHistoryMapper.toRestEntities(gActionsHistoryList, this.identityManager);
            RealizationList realizationList = new RealizationList();
            if (returnSize) {
                int realizationsSize = this.realizationsService.countRealizationsByFilter(filter, identity);
                realizationList.setSize(realizationsSize);
            }
            realizationList.setRealizations(gamificationActionsHistoryRestEntities);
            realizationList.setOffset(offset);
            realizationList.setLimit(limit);
            return Response.ok((Object)realizationList).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User '{}' isn't authorized to access achievements with parameter : earnerId = {}", new Object[]{identity.getUserId(), earnerIds, e});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="updateRealizations")
    @Operation(summary="Updates an existing realization", method="PUT", description="Updates an existing realization")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateRealizations(@Parameter(description="id of realization", required=true) @QueryParam(value="realizationId") String realizationId, @Parameter(description="new status of realization", required=true) @QueryParam(value="status") String status, @Parameter(description="new action Label of realization") @QueryParam(value="actionLabel") String actionLabel, @Parameter(description="new points of realization") @QueryParam(value="points") Long points, @Parameter(description="new domain of realization") @QueryParam(value="domain") String domain) {
        String currentUser = Utils.getCurrentUser();
        try {
            GamificationActionsHistoryDTO gamificationActionsHistoryDTO = this.realizationsService.updateRealizationStatus(Long.valueOf(realizationId), HistoryStatus.valueOf(status), actionLabel, points, domain);
            return Response.ok((Object)GamificationActionsHistoryMapper.toRestEntity(gamificationActionsHistoryDTO, this.identityManager)).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing realization '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"realization not found").build();
        }
    }
}

