/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.rest.model.GamificationActionsHistoryRestEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.GamificationActionsHistoryDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;

public class GamificationActionsHistoryMapper {
    private static final Log LOG = ExoLogger.getLogger(GamificationActionsHistoryMapper.class);

    private GamificationActionsHistoryMapper() {
    }

    public static GamificationActionsHistoryDTO fromEntity(GamificationActionsHistory gamificationActionsHistoryEntity) {
        Object objectId = "";
        objectId = gamificationActionsHistoryEntity.getActivityId() != null && gamificationActionsHistoryEntity.getActivityId() != 0L ? "/" + LinkProvider.getPortalName((String)"") + "/" + LinkProvider.getPortalOwner((String)"") + "/activity?id=" + gamificationActionsHistoryEntity.getActivityId() : gamificationActionsHistoryEntity.getObjectId();
        DomainEntity domainEntity = gamificationActionsHistoryEntity.getDomainEntity();
        return new GamificationActionsHistoryDTO(gamificationActionsHistoryEntity.getId(), gamificationActionsHistoryEntity.getEarnerId(), gamificationActionsHistoryEntity.getEarnerType().toString(), gamificationActionsHistoryEntity.getGlobalScore(), gamificationActionsHistoryEntity.getActionTitle(), domainEntity != null ? domainEntity.getTitle() : gamificationActionsHistoryEntity.getDomain(), gamificationActionsHistoryEntity.getContext(), gamificationActionsHistoryEntity.getActionScore(), gamificationActionsHistoryEntity.getReceiver(), (String)objectId, gamificationActionsHistoryEntity.getRuleId(), gamificationActionsHistoryEntity.getActivityId(), gamificationActionsHistoryEntity.getComment(), gamificationActionsHistoryEntity.getCreator(), gamificationActionsHistoryEntity.getCreatedBy(), Utils.toRFC3339Date(gamificationActionsHistoryEntity.getCreatedDate()), gamificationActionsHistoryEntity.getLastModifiedBy(), Utils.toRFC3339Date(gamificationActionsHistoryEntity.getLastModifiedDate()), gamificationActionsHistoryEntity.getStatus().name(), gamificationActionsHistoryEntity.getType());
    }

    public static List<GamificationActionsHistoryDTO> fromEntities(List<GamificationActionsHistory> gamificationActionsHistoryEntities) {
        if (CollectionUtils.isEmpty(gamificationActionsHistoryEntities)) {
            return new ArrayList<GamificationActionsHistoryDTO>(Collections.emptyList());
        }
        return gamificationActionsHistoryEntities.stream().map(GamificationActionsHistoryMapper::fromEntity).collect(Collectors.toList());
    }

    public static GamificationActionsHistory toEntity(GamificationActionsHistoryDTO gamificationActionsHistoryDTO) {
        if (gamificationActionsHistoryDTO == null) {
            return null;
        }
        GamificationActionsHistory gHistoryEntity = new GamificationActionsHistory();
        gHistoryEntity.setId(gamificationActionsHistoryDTO.getId());
        gHistoryEntity.setDomainEntity(DomainMapper.domainDTOToDomainEntity(Utils.getEnabledDomainByTitle(gamificationActionsHistoryDTO.getDomain())));
        gHistoryEntity.setDomain(gamificationActionsHistoryDTO.getDomain());
        gHistoryEntity.setActionTitle(gamificationActionsHistoryDTO.getActionTitle());
        gHistoryEntity.setActionScore(gamificationActionsHistoryDTO.getActionScore());
        gHistoryEntity.setGlobalScore(gamificationActionsHistoryDTO.getGlobalScore());
        gHistoryEntity.setActivityId(gamificationActionsHistoryDTO.getActivityId());
        gHistoryEntity.setObjectId(gamificationActionsHistoryDTO.getObjectId());
        gHistoryEntity.setReceiver(gamificationActionsHistoryDTO.getReceiver());
        gHistoryEntity.setEarnerId(gamificationActionsHistoryDTO.getEarnerId());
        gHistoryEntity.setEarnerType(IdentityType.getType(gamificationActionsHistoryDTO.getEarnerType()));
        gHistoryEntity.setContext(gamificationActionsHistoryDTO.getContext());
        gHistoryEntity.setComment(gamificationActionsHistoryDTO.getComment());
        gHistoryEntity.setRuleId(gamificationActionsHistoryDTO.getRuleId());
        gHistoryEntity.setCreator(gamificationActionsHistoryDTO.getCreator());
        gHistoryEntity.setStatus(HistoryStatus.valueOf(gamificationActionsHistoryDTO.getStatus()));
        gHistoryEntity.setType(gamificationActionsHistoryDTO.getType());
        if (gamificationActionsHistoryDTO.getCreatedDate() != null) {
            gHistoryEntity.setCreatedDate(Utils.parseRFC3339Date(gamificationActionsHistoryDTO.getCreatedDate()));
        } else {
            gHistoryEntity.setCreatedDate(new Date());
        }
        if (gamificationActionsHistoryDTO.getLastModifiedDate() != null) {
            gHistoryEntity.setLastModifiedDate(Utils.parseRFC3339Date(gamificationActionsHistoryDTO.getLastModifiedDate()));
        } else {
            gHistoryEntity.setLastModifiedDate(new Date());
        }
        gHistoryEntity.setCreatedBy(gamificationActionsHistoryDTO.getCreatedBy() != null ? gamificationActionsHistoryDTO.getCreatedBy() : "Gamification Inner Process");
        gHistoryEntity.setLastModifiedBy(gamificationActionsHistoryDTO.getLastModifiedBy() != null ? gamificationActionsHistoryDTO.getLastModifiedBy() : "Gamification Inner Process");
        return gHistoryEntity;
    }

    public static GamificationActionsHistoryRestEntity toRestEntity(GamificationActionsHistoryDTO gHistory, IdentityManager identityManager) {
        try {
            RuleDTO rule;
            String spaceName = "";
            if (gHistory.getRuleId() != null && gHistory.getRuleId() != 0L) {
                Space space;
                long spaceId;
                rule = Utils.getRuleById(gHistory.getRuleId());
                if (rule != null && (spaceId = rule.getAudience()) > 0L && (space = Utils.getSpaceById(String.valueOf(spaceId))) != null) {
                    spaceName = space.getDescription();
                }
            } else {
                spaceName = Utils.getSpaceFromObjectID(gHistory.getObjectId());
            }
            rule = gHistory.getRuleId() != null && gHistory.getRuleId() != 0L ? Utils.getRuleById(gHistory.getRuleId()) : Utils.getRuleByTitle(gHistory.getActionTitle());
            return new GamificationActionsHistoryRestEntity(gHistory.getId(), Utils.getIdentityEntity(identityManager, Long.parseLong(gHistory.getEarnerId())), rule, Utils.getDomainByTitle(gHistory.getDomain()), gHistory.getActionTitle() != null ? gHistory.getActionTitle() : Objects.requireNonNull(rule).getTitle(), gHistory.getActionScore(), Utils.getUserFullName(gHistory.getCreator() != null ? String.valueOf(gHistory.getCreator()) : gHistory.getReceiver()), gHistory.getCreatedDate(), gHistory.getStatus(), spaceName, gHistory.getObjectId());
        }
        catch (Exception e) {
            LOG.error("Error while mapping history with id {}", new Object[]{gHistory.getId(), e});
            return null;
        }
    }

    public static List<GamificationActionsHistoryRestEntity> toRestEntities(List<GamificationActionsHistoryDTO> gamificationActionsHistories, IdentityManager identityManager) {
        if (CollectionUtils.isEmpty(gamificationActionsHistories)) {
            return new ArrayList<GamificationActionsHistoryRestEntity>(Collections.emptyList());
        }
        return gamificationActionsHistories.stream().map(gamificationActionsHistoryDTO -> GamificationActionsHistoryMapper.toRestEntity(gamificationActionsHistoryDTO, identityManager)).collect(Collectors.toList());
    }
}

