/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.ConnectorAccount;
import io.meeds.gamification.model.RemoteConnector;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.gamification.storage.ConnectorAccountStorage;
import io.meeds.gamification.websocket.entity.ConnectorIdentifierModification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class ConnectorServiceImpl
implements ConnectorService {
    private static final Log LOG = ExoLogger.getLogger(ConnectorServiceImpl.class);
    public static final String CONNECTOR_NAME_IS_MANDATORY = "Connector name is mandatory";
    public static final String USERNAME_IS_MANDATORY = "Username is mandatory";
    public static final String CONNECTOR_REMOTE_ID_IS_MANDATORY = "connector RemoteId is mandatory";
    public static final String ACCESS_TOKEN_IS_MANDATORY = "Access Token is mandatory";
    public static final String IDENTIFIER_UPDATED_EVENT_NAME = "connector.identifier.updated";
    private final Map<String, ConnectorPlugin> connectorPlugins = new HashMap<String, ConnectorPlugin>();
    protected final ConnectorAccountStorage connectorAccountStorage;
    private final IdentityManager identityManager;
    private final ConnectorSettingService connectorSettingService;
    private final ListenerService listenerService;

    public ConnectorServiceImpl(ConnectorAccountStorage connectorAccountStorage, IdentityManager identityManager, ConnectorSettingService connectorSettingService, ListenerService listenerService) {
        this.connectorAccountStorage = connectorAccountStorage;
        this.connectorSettingService = connectorSettingService;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    @Override
    public void addPlugin(ConnectorPlugin connectorPlugin) {
        this.connectorPlugins.put(connectorPlugin.getName(), connectorPlugin);
    }

    @Override
    public void removePlugin(String name) {
        this.connectorPlugins.remove(name);
    }

    @Override
    public Collection<ConnectorPlugin> getConnectorPlugins() {
        return this.connectorPlugins.values();
    }

    @Override
    public Collection<RemoteConnector> getConnectors(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        ArrayList<RemoteConnector> connectorList = new ArrayList<RemoteConnector>();
        this.connectorPlugins.forEach((s, connectorPlugin) -> {
            RemoteConnector remoteConnector = new RemoteConnector();
            String connectorName = connectorPlugin.getConnectorName();
            remoteConnector.setName(connectorName);
            RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings(connectorName);
            if (remoteConnectorSettings != null) {
                remoteConnector.setApiKey(remoteConnectorSettings.getApiKey());
                remoteConnector.setRedirectUrl(remoteConnectorSettings.getRedirectUrl());
                remoteConnector.setEnabled(remoteConnectorSettings.isEnabled());
            }
            connectorList.add(remoteConnector);
        });
        return connectorList;
    }

    @Override
    public String connect(String connectorName, String connectorUserId, String accessToken, Identity userAclIdentity) {
        if (connectorName == null) {
            throw new IllegalArgumentException(CONNECTOR_NAME_IS_MANDATORY);
        }
        if (accessToken == null) {
            throw new IllegalArgumentException(ACCESS_TOKEN_IS_MANDATORY);
        }
        String username = userAclIdentity.getUserId();
        String userIdentityId = this.identityManager.getOrCreateUserIdentity(username).getId();
        connectorUserId = this.getConnectorPlugin(connectorName).validateToken(connectorUserId, accessToken);
        try {
            this.connectorAccountStorage.saveConnectorAccount(new ConnectorAccount(connectorName, connectorUserId, Long.parseLong(userIdentityId)));
        }
        catch (ObjectAlreadyExistsException e) {
            try {
                this.listenerService.broadcast(IDENTIFIER_UPDATED_EVENT_NAME, (Object)new ConnectorIdentifierModification("connectorIdentifierUsed", connectorName, username, connectorUserId), (Object)username);
            }
            catch (Exception exception) {
                LOG.warn("Error while broadcasting operation '{}' for connector {}", new Object[]{"connectorIdentifierUsed", connectorName, e});
            }
            return null;
        }
        try {
            this.listenerService.broadcast(IDENTIFIER_UPDATED_EVENT_NAME, (Object)new ConnectorIdentifierModification("connectorIdentifierUpdated", connectorName, username, connectorUserId), (Object)username);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting operation '{}' for connector {}", new Object[]{"connectorIdentifierUpdated", connectorName, e});
        }
        return connectorUserId;
    }

    @Override
    public void disconnect(String connectorName, String remoteId) {
        if (connectorName == null) {
            throw new IllegalArgumentException(CONNECTOR_NAME_IS_MANDATORY);
        }
        if (remoteId == null) {
            throw new IllegalArgumentException(CONNECTOR_REMOTE_ID_IS_MANDATORY);
        }
        this.connectorAccountStorage.deleteConnectorAccount(connectorName, remoteId);
    }

    @Override
    public String getConnectorRemoteId(String connectorName, String username) {
        if (connectorName == null) {
            throw new IllegalArgumentException(CONNECTOR_NAME_IS_MANDATORY);
        }
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY);
        }
        String userId = this.identityManager.getOrCreateUserIdentity(username).getId();
        return this.connectorAccountStorage.getConnectorRemoteId(connectorName, Long.parseLong(userId));
    }

    @Override
    public String getAssociatedUsername(String connectorName, String connectorRemoteId) {
        if (connectorName == null) {
            throw new IllegalArgumentException(CONNECTOR_NAME_IS_MANDATORY);
        }
        if (connectorRemoteId == null) {
            throw new IllegalArgumentException(CONNECTOR_REMOTE_ID_IS_MANDATORY);
        }
        long userId = this.connectorAccountStorage.getUserIdentityId(connectorName, connectorRemoteId);
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userId));
        if (userIdentity != null) {
            return userIdentity.getRemoteId();
        }
        return null;
    }

    private ConnectorPlugin getConnectorPlugin(String connectorName) {
        return this.connectorPlugins.get(connectorName);
    }
}

