/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.model.filter.EventFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class EventDAO
extends GenericDAOJPAImpl<EventEntity, Long> {
    public static final String TYPE = "type";
    public static final String TRIGGERS = "triggers";
    private static final String QUERY_FILTER_FIND_PREFIX = "Event.findAllEvents";
    private static final String QUERY_FILTER_COUNT_PREFIX = "Event.countAllEvents";
    public static final String TITLE = "title";
    public static final String TRIGGER = "trigger";
    private final Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();

    public EventEntity getEventByTitleAndTrigger(String title, String trigger) {
        TypedQuery query = this.getEntityManager().createNamedQuery("EventEntity.getEventByTitleAndTrigger", EventEntity.class);
        query.setParameter(TITLE, (Object)title);
        query.setParameter(TRIGGER, (Object)trigger);
        try {
            return (EventEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public EventEntity getEventByTypeAndTitle(String type, String title) {
        TypedQuery query = this.getEntityManager().createNamedQuery("EventEntity.getEventByTypeAndTitle", EventEntity.class);
        query.setParameter(TYPE, (Object)type);
        query.setParameter(TITLE, (Object)title);
        try {
            return (EventEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<EventEntity> getEventsByTitle(String title, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("EventEntity.getEventsByTitle", EventEntity.class);
        query.setParameter(TITLE, (Object)title);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<EventEntity> findEventsByFilter(EventFilter filter, int offset, int limit) {
        TypedQuery<EventEntity> query = this.buildQueryFromFilter(filter, EventEntity.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public int countEventByFilter(EventFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(EventFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private <T> void addQueryFilterParameters(EventFilter filter, TypedQuery<T> query) {
        if (StringUtils.isNotBlank((String)filter.getType())) {
            query.setParameter(TYPE, (Object)filter.getType());
        }
        if (CollectionUtils.isNotEmpty(filter.getTriggers())) {
            query.setParameter(TRIGGERS, filter.getTriggers());
        }
    }

    private String getQueryFilterContent(List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(event) FROM EventEntity event " : "SELECT DISTINCT event FROM EventEntity event ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + org.apache.commons.lang3.StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + " ORDER BY event.id  DESC ";
        }
        return queryContent;
    }

    private void buildPredicates(EventFilter filter, List<String> suffixes, List<String> predicates) {
        if (StringUtils.isNotBlank((String)filter.getType())) {
            suffixes.add("Type");
            predicates.add("event.type = :type");
        }
        if (CollectionUtils.isNotEmpty(filter.getTriggers())) {
            suffixes.add("Triggers");
            predicates.add("event.trigger IN :triggers");
        }
    }
}

