/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.provider.builder;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class ActionPublishedTemplateBuilder
extends AbstractTemplateBuilder {
    private RuleService ruleService;
    private TranslationService translationService;
    private TemplateProvider templateProvider;
    private boolean pushNotification;

    public ActionPublishedTemplateBuilder(RuleService ruleService, TranslationService translationService, TemplateProvider templateProvider, boolean pushNotification) {
        this.ruleService = ruleService;
        this.translationService = translationService;
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String ruleId = notification.getValueOwnerParameter("RULE_ID");
        String publisher = notification.getValueOwnerParameter("PUBLISHER");
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return null;
        }
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(ruleId));
        if (rule == null || rule.isDeleted() || rule.getProgram() == null || rule.getProgram().isDeleted()) {
            return null;
        }
        ProgramDTO program = rule.getProgram();
        Identity identity = Utils.getUserIdentity(publisher);
        if (identity == null || identity.isDeleted() || !identity.isEnable()) {
            return null;
        }
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        Locale userLocale = new Locale(language);
        String ruleTitle = this.translationService.getTranslationLabel("rule", Long.parseLong(ruleId), "title", userLocale);
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            ruleTitle = rule.getTitle();
        }
        templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
        templateContext.put((Object)"USER_AVATAR", (Object)(identity.getProfile().getAvatarUrl() != null ? identity.getProfile().getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
        templateContext.put((Object)"USER_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
        templateContext.put((Object)"PROGRAM_AVATAR", (Object)program.getAvatarUrl());
        templateContext.put((Object)"RULE_ID", (Object)String.valueOf(ruleId));
        templateContext.put((Object)"RULE_TITLE", (Object)ruleTitle);
        templateContext.put((Object)"RULE_EVENT", rule.getType() == EntityType.AUTOMATIC ? rule.getEvent() : "");
        String ruleUrl = LinkProviderUtils.getRedirectUrl((String)"view_full_activity", (String)String.valueOf(rule.getActivityId()));
        templateContext.put((Object)"RULE_URL", (Object)ruleUrl);
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)new Date(notification.getLastModifiedDate()), (String)"EE, dd yyyy", (Locale)userLocale, (int)TimeConvertUtils.YEAR));
        MessageInfo messageInfo = new MessageInfo();
        if (this.pushNotification) {
            messageInfo.subject(ruleUrl);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
        }
        messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
        ctx.setException(templateContext.getException());
        return messageInfo.end();
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }
}

