/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.dao.ConnectorAccountDAO;
import io.meeds.gamification.model.ConnectorAccount;
import io.meeds.gamification.storage.ConnectorAccountStorage;
import io.meeds.gamification.storage.cached.model.ConnectorAccountCachedKey;
import java.io.Serializable;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConnectorAccountCachedStorage
extends ConnectorAccountStorage {
    private static final Log LOG = ExoLogger.getLogger(ConnectorAccountCachedStorage.class);
    public static final String CONNECTOR_CACHE_NAME = "gamification.connectors";
    public static final String CONNECTOR_ACCOUNT_BY_REMOTE_ID = "accountByRemoteId";
    public static final String CONNECTOR_REMOTE_CONTEXT = "remoteId";
    public static final String CONNECTOR_LOCAL_CONTEXT = "userId";
    private ExoCache<ConnectorAccountCachedKey, Object> cacheInstance;
    private FutureExoCache<ConnectorAccountCachedKey, Object, String> futureCache;

    public ConnectorAccountCachedStorage(ConnectorAccountDAO connectorAccountDAO, CacheService cacheService) {
        super(connectorAccountDAO);
        this.cacheInstance = cacheService.getCacheInstance(CONNECTOR_CACHE_NAME);
        this.futureCache = new FutureExoCache((Loader)new Loader<ConnectorAccountCachedKey, Object, String>(){

            public Object retrieve(String context, ConnectorAccountCachedKey key) throws Exception {
                if (ConnectorAccountCachedStorage.CONNECTOR_REMOTE_CONTEXT.equals(context)) {
                    return ConnectorAccountCachedStorage.super.getConnectorRemoteId(key.getConnectorName(), key.getUserId());
                }
                if (ConnectorAccountCachedStorage.CONNECTOR_ACCOUNT_BY_REMOTE_ID.equals(context)) {
                    return ConnectorAccountCachedStorage.super.getConnectorAccount(key.getConnectorName(), key.getUserId());
                }
                if (ConnectorAccountCachedStorage.CONNECTOR_LOCAL_CONTEXT.equals(context)) {
                    return ConnectorAccountCachedStorage.super.getUserIdentityId(key.getConnectorName(), key.getRemoteId());
                }
                throw new UnsupportedOperationException();
            }
        }, this.cacheInstance);
    }

    @Override
    public String getConnectorRemoteId(String connectorName, long userId) {
        ConnectorAccountCachedKey cacheKey = new ConnectorAccountCachedKey(connectorName, userId, false);
        try {
            String connectorRemoteId = (String)this.futureCache.get((Object)CONNECTOR_REMOTE_CONTEXT, (Object)cacheKey);
            if (this.futureCache.get((Serializable)new ConnectorAccountCachedKey(connectorName, connectorRemoteId)) == null && connectorRemoteId != null) {
                this.futureCache.put((Serializable)new ConnectorAccountCachedKey(connectorName, connectorRemoteId), (Object)userId);
            }
            return connectorRemoteId;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when getting connector remote Id cache", (Throwable)e);
            return null;
        }
    }

    @Override
    public ConnectorAccount getConnectorAccount(String connectorName, long userId) {
        ConnectorAccountCachedKey cacheKey = new ConnectorAccountCachedKey(connectorName, userId, true);
        try {
            return (ConnectorAccount)this.futureCache.get((Object)CONNECTOR_ACCOUNT_BY_REMOTE_ID, (Object)cacheKey);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when getting connector remote Id cache", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getUserIdentityId(String connectorName, String connectorRemoteId) {
        ConnectorAccountCachedKey cacheKey = new ConnectorAccountCachedKey(connectorName, connectorRemoteId);
        try {
            return (Long)this.futureCache.get((Object)CONNECTOR_LOCAL_CONTEXT, (Object)cacheKey);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when getting connector user Id cache", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public void saveConnectorAccount(ConnectorAccount connectorAccount) throws ObjectAlreadyExistsException {
        try {
            super.saveConnectorAccount(connectorAccount);
        }
        finally {
            this.clearCacheEntries(connectorAccount.getConnectorName(), connectorAccount.getRemoteId());
            this.clearCacheEntries(connectorAccount.getConnectorName(), connectorAccount.getUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectorAccount deleteConnectorAccount(String connectorName, String connectorRemoteId) {
        try {
            ConnectorAccount connectorAccount = super.deleteConnectorAccount(connectorName, connectorRemoteId);
            return connectorAccount;
        }
        finally {
            this.clearCacheEntries(connectorName, connectorRemoteId);
        }
    }

    public void clearCacheEntries(final String connectorName, final String connectorRemoteId) {
        try {
            this.cacheInstance.select((CachedObjectSelector)new CachedObjectSelector<ConnectorAccountCachedKey, Object>(){

                public boolean select(ConnectorAccountCachedKey key, ObjectCacheInfo<? extends Object> ocinfo) {
                    return StringUtils.equals((CharSequence)key.getConnectorName(), (CharSequence)connectorName) && StringUtils.equals((CharSequence)key.getRemoteId(), (CharSequence)connectorRemoteId);
                }

                public void onSelect(ExoCache<? extends ConnectorAccountCachedKey, ? extends Object> cache, ConnectorAccountCachedKey key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                    Long userIdentityId = (Long)cache.get((Serializable)key);
                    if (userIdentityId != null) {
                        cache.remove((Serializable)new ConnectorAccountCachedKey(connectorName, userIdentityId, false));
                        cache.remove((Serializable)new ConnectorAccountCachedKey(connectorName, userIdentityId, true));
                    }
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Unable to clean cache entry for connector {} and account name {}. Clean all cache entries to preserve coherence.", new Object[]{connectorName, connectorRemoteId, e});
            this.cacheInstance.clearCache();
        }
    }

    public void clearCacheEntries(final String connectorName, final long userIdentityId) {
        try {
            this.cacheInstance.select((CachedObjectSelector)new CachedObjectSelector<ConnectorAccountCachedKey, Object>(){

                public boolean select(ConnectorAccountCachedKey key, ObjectCacheInfo<? extends Object> ocinfo) {
                    return StringUtils.equals((CharSequence)key.getConnectorName(), (CharSequence)connectorName) && key.getUserId() == userIdentityId;
                }

                public void onSelect(ExoCache<? extends ConnectorAccountCachedKey, ? extends Object> cache, ConnectorAccountCachedKey key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                    String remoteId = (String)cache.get((Serializable)key);
                    if (remoteId != null) {
                        cache.remove((Serializable)new ConnectorAccountCachedKey(connectorName, remoteId));
                    }
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Unable to clean cache entry for connector {} and user identity id {}. Clean all cache entries to preserve coherence.", new Object[]{connectorName, userIdentityId, e});
            this.cacheInstance.clearCache();
        }
    }
}

