/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RulePublication;
import io.meeds.gamification.test.AbstractPluginTest;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;

public class ActionPublishedNotificationPluginTest
extends AbstractPluginTest {
    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        return null;
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"GamificationActionPublishedNotification"));
    }

    public void testSimpleCase() throws Exception {
        this.notificationService.clearAll();
        ProgramDTO program = new ProgramDTO();
        program.setTitle("TeamWork");
        program.setDescription("TeamWork");
        program.setCreatedBy("1");
        program.setLastModifiedBy("1");
        program.setDeleted(false);
        program.setEnabled(true);
        program.setSpaceId(1L);
        program = this.programService.createProgram(program);
        RulePublication rule = new RulePublication();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription("Description");
        rule.setEnabled(true);
        rule.setDeleted(false);
        EventDTO event = new EventDTO();
        event.setTitle("createNewTask");
        event.setTrigger("createNewTask");
        event.setType("eventType");
        event = this.eventService.createEvent(event);
        rule.setEvent(event);
        rule.setProgram(program);
        rule.setType(EntityType.AUTOMATIC);
        rule.setRecurrence(RecurrenceType.NONE);
        rule.setPublish(true);
        String message = "Test publication Message";
        rule.setMessage(message);
        RuleDTO createdRule = this.ruleService.createRule((RuleDTO)rule, "root1");
        ActionPublishedNotificationPluginTest.assertTrue((createdRule.getActivityId() > 0L ? 1 : 0) != 0);
        List<NotificationInfo> list = this.assertMadeWebNotifications("root5", 1);
        NotificationInfo rulePublicationNotification = list.get(0);
        ActionPublishedNotificationPluginTest.assertEquals((String)"GamificationActionPublishedNotification", (String)rulePublicationNotification.getKey().getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(rulePublicationNotification.setTo("root5"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, rule.getTitle());
        ActionPublishedNotificationPluginTest.assertEquals((long)1L, (long)rulePublicationNotification.getSpaceId());
    }
}

