/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.highlight.spaces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class HighlightedSpacesService {
    private List<String> highlightedSpaces = new ArrayList<String>();
    private final String HIGHLIGHED_SPACES = "exo.addons.highlightedSpaces";
    private SpaceService spaceService;
    private final ExoCache<String, List<Space>> highlightedSpacesCache;

    public HighlightedSpacesService(SpaceService spaceService, CacheService cacheService) {
        String[] spaceName;
        String highlightedSpacesProperty = System.getProperty("exo.addons.highlightedSpaces", "").trim();
        for (String space : spaceName = highlightedSpacesProperty.split(",")) {
            if (space.equals("")) continue;
            this.highlightedSpaces.add(space.trim());
        }
        this.spaceService = spaceService;
        this.highlightedSpacesCache = cacheService.getCacheInstance(this.getClass().getName() + "Cache");
    }

    public List<Space> getUserHighlightedSpaces(String remoteUser) {
        List cachedResults = (List)this.highlightedSpacesCache.get((Serializable)((Object)remoteUser));
        if (cachedResults != null) {
            return this.cleanCachedResult(cachedResults);
        }
        ArrayList<Space> results = new ArrayList<Space>();
        for (String spaceName : this.highlightedSpaces) {
            Space space = this.spaceService.getSpaceByPrettyName(spaceName);
            if (space == null || !this.spaceService.isMember(space, remoteUser)) continue;
            results.add(space);
        }
        this.highlightedSpacesCache.put((Serializable)((Object)remoteUser), results);
        return results;
    }

    public void invalidate(String target) {
        this.highlightedSpacesCache.remove((Serializable)((Object)target));
    }

    private List<Space> cleanCachedResult(List<Space> cachedResults) {
        ArrayList<Space> cleanedCachedResults = new ArrayList<Space>();
        for (Space cachedResult : cachedResults) {
            Space space = this.spaceService.getSpaceByPrettyName(cachedResult.getPrettyName());
            if (space == null) continue;
            cleanedCachedResults.add(space);
        }
        return cleanedCachedResults;
    }
}

