/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.intercom.rs;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.security.RolesAllowed;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.json.JSONObject;

@Path(value="intercom/settings")
@Produces(value={"application/json"})
public class IntercomSettings
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(IntercomSettings.class);
    private OrganizationService orgService_ = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
    private UserHandler userHandler = this.orgService_.getUserHandler();
    private IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManagerImpl.class);
    private static String USER_ID_KEY = "user_id";
    private static String USER_NAME_KEY = "user_name";
    private static String USER_EMAIL_KEY = "user_email";
    private static String USER_SIGNIN_DATE_KEY = "user_signin_date";
    private static String INTERCOM_APP_ID_KEY = "APP_ID";
    private static String INTERCOM_HMAC_KEY = "HMAC";
    private static String INTERCOM_SETTINGS_APP_ID = "intercom.settings.appid";
    private static String INTERCOM_SETTINGS_SECRET = "intercom.settings.secretkey";
    private static final CacheControl cacheControl = new CacheControl();

    @GET
    @Path(value="/respond")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response respondSettings() throws Exception {
        JSONObject jsonGlobal = new JSONObject();
        JSONObject jsonUser = new JSONObject();
        try {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            String userName = currentIdentity.getUserId();
            User user = this.userHandler.findUserByName(userName);
            org.exoplatform.social.core.identity.model.Identity socialIdentity = this.identityManager.getOrCreateIdentity("organization", userName, false);
            Profile currentProfile = socialIdentity.getProfile();
            jsonUser.put(INTERCOM_APP_ID_KEY, (Object)PropertyManager.getProperty((String)INTERCOM_SETTINGS_APP_ID));
            jsonUser.put(INTERCOM_HMAC_KEY, (Object)this.generateHMAC(userName, PropertyManager.getProperty((String)INTERCOM_SETTINGS_SECRET)));
            jsonUser.put(USER_ID_KEY, (Object)user.getUserName());
            jsonUser.put(USER_NAME_KEY, (Object)user.getDisplayName());
            jsonUser.put(USER_EMAIL_KEY, (Object)user.getEmail());
            jsonUser.put(USER_SIGNIN_DATE_KEY, user.getLastLoginTime().getTime());
            jsonGlobal.put("user", (Object)jsonUser);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
    }

    private String generateHMAC(String userid, String secret) {
        Mac sha256_HMAC = null;
        StringBuffer result = new StringBuffer();
        try {
            byte[] hash;
            sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            for (byte b : hash = sha256_HMAC.doFinal(userid.getBytes())) {
                result.append(String.format("%02X", b));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result.toString();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

