/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi.portlet;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.jitsi.JitsiProvider;
import org.exoplatform.webui.application.WebuiRequestContext;

public class JitsiPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(JitsiPortlet.class);
    private WebConferencingService webConferencing;
    private JitsiProvider provider;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
        try {
            this.provider = (JitsiProvider)this.webConferencing.getProvider("jitsi");
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider jitsi isn't an instance of " + JitsiProvider.class.getName()), (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.provider != null) {
            try {
                JitsiProvider.JitsiSettings settings = this.provider.getSettings();
                settings.addMessages(Utils.getResourceMessages((String)"locale.jitsi.Jitsi", (Locale)request.getLocale()));
                String settingsJson = Utils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/webConferencing", "webConferencing").require("SHARED/webConferencing_jitsi", "jitsi").require("SHARED/webConferencingPortlet", "webConferencingPortlet").addScripts("async function registerProvider() {  if (jitsi) {     await webConferencingPortlet.start();    jitsi.configure(" + settingsJson + ");    webConferencing.addProvider(jitsi);     webConferencing.update();   }}registerProvider();");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing Jitsi calls portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }
}

